# -*- coding:utf-8 -*-

import ConfigParser
import os.path
import doUI 
from qsphere_tools import *
from qsphere_objmaker import *
from importexport import *

from datetime import date
import datetime
from PyQt4 import QtCore, QtGui
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import * 
from PyQt4.QtGui import * 
from qgis.core import *
from qgis.gui import *

class Ui_Dialog_Metadata(object):
    def __init__(self, iface):
        self.iface = iface
    
    def setupUi(self, Dialog):
        Dialog.setObjectName("Dialog")
        Dialog.setAccessibleName("Dialog")
        MakeWindowIcon(self, "qsp.png")
        sizeW, sizeH = 1100, 660

        overrideLocale = QSettings().value("locale/overrideFlag", False)
        localeFullName = QLocale.system().name() if not overrideLocale else QSettings().value("locale/userLocale", "")
        self.Lang = "fr" if localeFullName[0:2]=="fr" else "en"
        self.TypeData = ("dataset", "whole dataset", "service")
        self.ListUnitsMesure = ["m", "km", "foot", "inch", "mile", "yard"]

        self.initDir = self.ToolTipLangue = ""
        self.ListOfConformities = LoadDefautValue(self, "file:/ressources/conformity_default.csv")
        self.ListOfRules, self.DicoListOfRules = LoadData(self, "file:/ressources/roles.csv", "roles")
        self.ListOfThesaurus , self.DateListOfThesaurus = LoadData(self, "file:/ressources/thesaurus.csv", "thesaurus")
        self.ListFormats = self.formats
        self.racWindowTitle = QtGui.QApplication.translate("QSphere","Information metadata : ", None, QtGui.QApplication.UnicodeUTF8)
        self.ListTypeDates = [QtGui.QApplication.translate("QSphere","Date of creation", None, QtGui.QApplication.UnicodeUTF8), \
                              QtGui.QApplication.translate("QSphere","Date of last revision", None, QtGui.QApplication.UnicodeUTF8), \
                              QtGui.QApplication.translate("QSphere","Date of publication", None, QtGui.QApplication.UnicodeUTF8),]
        self.ListDegres = [QtGui.QApplication.translate("QSphere","Conformant", None, QtGui.QApplication.UnicodeUTF8), \
                           QtGui.QApplication.translate("QSphere","Not conformant", None, QtGui.QApplication.UnicodeUTF8), \
                           QtGui.QApplication.translate("QSphere","Not evaluated", None, QtGui.QApplication.UnicodeUTF8)]
        
        Dialog.setMinimumSize(QtCore.QSize(sizeW-30, sizeH))
        Dialog.setMaximumSize(QtCore.QSize(sizeW-30, sizeH))
        Dialog.resize(QtCore.QSize(QtCore.QRect(0,0,sizeW-30,sizeH).size()).expandedTo(Dialog.minimumSizeHint()))
        Dialog.setWindowTitle(self.racWindowTitle) 
        
        self.tabWidget = QtGui.QTabWidget(Dialog)
        self.tabWidget.setObjectName("tabWidget")
        self.tabWidget.setGeometry(QtCore.QRect(280, 10, 780, 620)) 

        myPathIconvRightArrow = getThemeIcon("rightarrow.png")
        myPathIconvLeftArrow = getThemeIcon("leftarrow.png")
        self.tabWidget.setStyleSheet(
            """QTabBar::tab:selected {color: #5D5D5D;background-color: rgb(255,255,255);}"""
            """QTabBar::tab:!selected {color: rgb(255,255,255);background-color: #5D5D5D;border-bottom-color: #5D5D5D;}"""
            """QTabWidget:pane {margin: 1px,1px,1px,1px;background-color: rgb(255,255,255);}"""
            """QTabBar::tab {border: 0px solid rgb(0,149,48);border-bottom-color: rgb(255,255,255);border-top-left-radius: 0px;border-top-right-radius: 0px;height: 0px;width: 170px;background-color: rgb(255,255,255);}"""
            """QTabWidget{background-color: rgb(255,255,255);font: 75 10pt "Arial Rounded MT Bold";}"""
            """QTabWidget::tab-bar {left: 5px; bottom: -1px;background-color: rgb(0,0,0); } """
            """QTabBar::scroller {width: 0px;}"""
        )
        self.tabWidget.setTabPosition(QtGui.QTabWidget.South) 
        self.tabWidget.setTabShape(QtGui.QTabWidget.Rounded)
        self.tabWidget.setUsesScrollButtons(True)

        zTitle = (QtGui.QApplication.translate("QSphere","Identification", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Classification & Keywords", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Geographic", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Temporal", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Quality, Validity and Conformity", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Constraints", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Responsible party", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Metadata", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","QGIS metadata", None, QtGui.QApplication.UnicodeUTF8),
                  )

        zIcons = ("identification.png", "classification.png", "location.png", "temporality.png", "quality.png", "rights_and_uses.png", "responsible.png", "metadata.png", "qgis.png")

        zToolTip = (QtGui.QApplication.translate("QSphere","Identification data (title, abstract,\ntype, encoding ...)", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Classification & Keywords", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Geographical location", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Dates temporal referencing", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Quality, Validity and Conformity", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Access and uses", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Responsible party", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Metadata", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Metadata by QGIS", None, QtGui.QApplication.UnicodeUTF8),
                  )

        SizeLabelW, SizeLabelH = 60, 25
        self.SizeWW, self.SizeWH = 200, 25
        self.EmpriseLat, self.EmpriseLong = 180, 360

        self.listWidget = QListWidget(Dialog)
        self.listWidget.setGeometry(QtCore.QRect(10, 10, 280, 620))
        self.listWidget.setObjectName("listWidget")
        self.listWidget.setStyleSheet("* { background-color:#5D5D5D; padding: 4px ; color:rgb(255,255,255)}"
                                      "QListWidget::item:selected {color: #5D5D5D;background-color: rgb(255,255,255);  padding: 12px;}")
        self.listWidget.setIconSize(QSize(42, 42))             

        self.listeOnglets = QComboBox(Dialog)
        self.listeOnglets.setToolTip(QtGui.QApplication.translate("QSphere","List of tabs", None, QtGui.QApplication.UnicodeUTF8)) 
        self.listeOnglets.setGeometry(QtCore.QRect(510, sizeH-30, 190, SizeLabelH))
        self.listeOnglets.setObjectName("listeOnglets")        
        
        zScroll = {}
        for i in range(1,len(zTitle)+1):
            zIcon = getThemeIcon(zIcons[i-1])
            zItem =  QListWidgetItem(QIcon(zIcon),zTitle[i-1],self.listWidget)
            zItem.setToolTip(zToolTip[i-1])

            zTab = QtGui.QWidget(Dialog)
            zTab.setObjectName("tab%s" % (i))
            zTab.setAccessibleName(zTitle[i-1])
            
            self.tabWidget.addTab(zTab, zTitle[i-1])
            self.tabWidget.setTabToolTip(i-1, zToolTip[i-1])
            self.listeOnglets.addItem(zTitle[i-1])
            makeTABWidgets(self, zTab, i, SizeLabelW, SizeLabelH, self.SizeWW, self.SizeWH)

        self.barInfo = QgsMessageBar(Dialog)
        self.barInfo.setSizePolicy( QSizePolicy.Minimum, QSizePolicy.Fixed )
        self.barInfo.setGeometry(QtCore.QRect(0, 0, sizeW-10, 50))


        self.langs_gui = QLabel(self)
        self.langs_gui.setGeometry(QtCore.QRect(11, 540, 278, 15))
        myDefPathIcon = getThemeIcon("langs_gui.png")
        carIcon = QtGui.QImage(myDefPathIcon) 
        self.langs_gui.setPixmap(QtGui.QPixmap.fromImage(carIcon))
        self.langs_gui.setToolTip(QtGui.QApplication.translate("QSphere","Langs for the GUI", None, QtGui.QApplication.UnicodeUTF8))
        

        self.progressBar = QProgressBar(self)
        self.progressBar.setProperty("value", 0)
        self.progressBar.setAlignment(QtCore.Qt.AlignCenter)
        self.progressBar.setTextVisible(True)
        self.progressBar.setObjectName("progressBar")
        self.progressBar.setStyleSheet(
             """QProgressBar {border: 2px solid grey; border-radius: 5px; text-align: center;}"""
             """QProgressBar::chunk {background-color: #6C96C6; width: 20px;}"""
        )
        self.progressBar.setVisible(False)
        self.progressBar.setGeometry(QtCore.QRect(20, 585, 260, 15))
        self.progressBar.setValue(0)

        self.LblComboLayers = QLabel(Dialog)
        self.LblComboLayers.setGeometry(QtCore.QRect(10, sizeH-25, 150, SizeLabelH))
        self.LblComboLayers.setAlignment(Qt.AlignRight)
        self.LblComboLayers.setObjectName("LblComboLayers")
        self.LblComboLayers.setText(QtGui.QApplication.translate("QSphere","Query a layer : ", None, QtGui.QApplication.UnicodeUTF8)) 

        self.ComboLayers = QtGui.QComboBox(Dialog)
        self.ComboLayers.setGeometry(QtCore.QRect(170, sizeH-30, 250, SizeLabelH))
        self.ComboLayers.setObjectName("ComboLayers")
        self.ComboLayers.setAccessibleName("ComboLayers")

        self.modelLayers = QtGui.QStandardItemModel()
        MakeListLayer(self, self.modelLayers, self.ComboLayers)
        self.GetMetaData()

        zIcon = getThemeIcon("new.png")
        zToolTip = QtGui.QApplication.translate("QSphere","New sheet", None, QtGui.QApplication.UnicodeUTF8)
        self.NewButton = MyPushButton(self) 
        self.NewButton.initPushButton(24, 24, 750, sizeH-30, "NewButton", "", zToolTip, True, zIcon, 24, 24, True)

        zIcon = getThemeIcon("open.png")
        zToolTip = QtGui.QApplication.translate("QSphere","Load Data ...", None, QtGui.QApplication.UnicodeUTF8)
        self.LoadButton = MyPushButton(self) 
        self.LoadButton.initPushButton(24, 24, 780, sizeH-30, "LoadButton", "", zToolTip, True, zIcon, 24, 24, True)

        zIcon = getThemeIcon("save.png")
        zToolTip = QtGui.QApplication.translate("QSphere","Save the current sheet QSphere", None, QtGui.QApplication.UnicodeUTF8)
        self.SaveButton = MyPushButton(self) 
        self.SaveButton.initPushButton(24, 24, 820, sizeH-30, "SaveButton", "", zToolTip, True, zIcon, 24, 24, True)

        zIcon = getThemeIcon("saveas.png")
        zToolTip = QtGui.QApplication.translate("QSphere","Save AS the current sheet QSphere", None, QtGui.QApplication.UnicodeUTF8)
        self.SaveAsButton = MyPushButton(self) 
        self.SaveAsButton.initPushButton(24, 24, 850, sizeH-30, "SaveAsButton", "", zToolTip, True, zIcon, 24, 24, True)

        zIcon = getThemeIcon("export.png")
        zToolTip = QtGui.QApplication.translate("QSphere","Export record QSphere in XML File", None, QtGui.QApplication.UnicodeUTF8)
        self.XMLButton = MyPushButton(self) 
        self.XMLButton.initPushButton(24, 24, 880, sizeH-30, "XMLButton", "", zToolTip, True, zIcon, 24, 24, True)

        zIcon = getThemeIcon("help.png")
        zToolTip = QtGui.QApplication.translate("QSphere","Call the help page", None, QtGui.QApplication.UnicodeUTF8)
        self.HelpButton = MyPushButton(self) 
        self.HelpButton.initPushButton(24, 24, 920, sizeH-30, "HelpButton", "", zToolTip, True, zIcon, 24, 24, True)

        self.CloseButton = MyButton(self)
        zText = QtGui.QApplication.translate("QSphere","Close", None, QtGui.QApplication.UnicodeUTF8)
        zToolTip = QtGui.QApplication.translate("QSphere","Close the dialog box", None, QtGui.QApplication.UnicodeUTF8)
        self.CloseButton.initButton(100, SizeLabelH, 960, sizeH-30, "CloseButton", zText, zToolTip , True, True) 

        self.leftB = QToolButton(Dialog)
        self.leftB.setToolTip(QtGui.QApplication.translate("QSphere","Previous tab", None, QtGui.QApplication.UnicodeUTF8)) 
        self.leftB.setGeometry(QtCore.QRect(480, sizeH-30, SizeLabelH, SizeLabelH))
        self.leftB.setStyleSheet( """QToolButton { qproperty-icon: url("""+myPathIconvLeftArrow+""");}"""
                                  """QToolButton:pressed { qproperty-icon: url("""+myPathIconvLeftArrow+""");}"""
                                  """QToolButton:hover { qproperty-icon: url("""+myPathIconvLeftArrow+""");}"""
                                 )
        self.leftB.setObjectName("leftB")

        self.rightB = QToolButton(Dialog)
        self.rightB.setToolTip(QtGui.QApplication.translate("QSphere","Next tab", None, QtGui.QApplication.UnicodeUTF8))
        self.rightB.setGeometry(QtCore.QRect(705, sizeH-30, SizeLabelH, SizeLabelH))
        self.rightB.setStyleSheet( """QToolButton { qproperty-icon: url("""+myPathIconvRightArrow+""");}"""
                                  """QToolButton:pressed { qproperty-icon: url("""+myPathIconvRightArrow+""");}"""
                                  """QToolButton:hover { qproperty-icon: url("""+myPathIconvRightArrow+""");}"""
                                 )
        self.rightB.setObjectName("rightB")
        
        QtCore.QObject.connect(self.NewButton,QtCore.SIGNAL("clicked()"),self.NewSheet)
        self.contextMnuLoadData()
        QtCore.QObject.connect(self.SaveAsButton,QtCore.SIGNAL("clicked()"),self.SaveAsDataQSP)
        QtCore.QObject.connect(self.SaveButton,QtCore.SIGNAL("clicked()"),self.SaveDataQSP)

        self.contextMnuSaveXML()
        
        QtCore.QObject.connect(self.HelpButton, QtCore.SIGNAL("clicked()"), self.GetHelpFile)
        QtCore.QObject.connect(self.CloseButton,QtCore.SIGNAL("clicked()"),self.close)
        QtCore.QObject.connect(self.rightB, SIGNAL("clicked()"), self.fixeTABPLUS)
        QtCore.QObject.connect(self.leftB, SIGNAL("clicked()"), self.fixeTABMOINS)
        QtCore.QObject.connect(self.ComboLayers,QtCore.SIGNAL("currentIndexChanged(QString)"), self.GetMetaData)
        QtCore.QObject.connect(self.listeOnglets,QtCore.SIGNAL("currentIndexChanged(QString)"),self.fixeTAB)
        QtCore.QObject.connect(self.tabWidget, QtCore.SIGNAL("currentChanged(int)"), self.fixeONGLET)
        QtCore.QObject.connect(self.listWidget, QtCore.SIGNAL("currentRowChanged(int)"), self.fixeONGLETL)
        
        QtCore.QMetaObject.connectSlotsByName(Dialog)
        self.DessCadre()
        self.tabWidget.setCurrentIndex(0)
        self.listWidget.setCurrentRow(0)
        self.fixeONGLET()
        self.CountLangues()


    def LoadGeoLocalisator(self):
        zObj = zObj = getWidget(self, "tableemprises")
        if zObj.currentRow()==-1 : zObj.selectRow(0)
        zEmprise = []
        for j in range(zObj.columnCount()-1): zEmprise.append(zObj.cellWidget(zObj.currentRow(),j).value())
        zUrl = "file:geolocalisator.html"
        d = doUI.DialogViewer(self.iface, zUrl, False, zEmprise)
        d.exec_()
        
    def contextMnuLoadData(self):
        contextMnu_LoadData = QMenu()
        
        menuIcon = getThemeIcon("loadqsp.png")
        zText = QtGui.QApplication.translate("QSphere","Load a sheet QSphere ...", None, QtGui.QApplication.UnicodeUTF8)
        self.loadQSP = QAction(QIcon(menuIcon), zText, self)
        contextMnu_LoadData.addAction(self.loadQSP)
        QObject.connect(self.loadQSP,SIGNAL("triggered()"),self.loadDataQSP)

        contextMnu_LoadData.addSeparator()
        
        menuIcon = getThemeIcon("loadxml.png")
        zText = QtGui.QApplication.translate("QSphere","Import Data from XML ISO 19139 ...", None, QtGui.QApplication.UnicodeUTF8)
        self.loadXML = QAction(QIcon(menuIcon), zText, self)
        contextMnu_LoadData.addAction(self.loadXML)
        QObject.connect(self.loadXML,SIGNAL("triggered()"),self.LoadDataFromXML)
        
        contextMnu_LoadData.addSeparator()

        menuIcon = getThemeIcon("viewxml.png")
        zText = QtGui.QApplication.translate("QSphere","View metadata XML ISO 19139 ...", None, QtGui.QApplication.UnicodeUTF8)
        self.viewXML = QAction(QIcon(menuIcon), zText, self)
        contextMnu_LoadData.addAction(self.viewXML)
        QObject.connect(self.viewXML,SIGNAL("triggered()"),self.ViewDataFromXML)

        self.LoadButton.setMenu(contextMnu_LoadData)
        
    def contextMnuSaveXML(self):
        contextMnu_XML = QMenu()
        
        menuIcon = getThemeIcon("iso.png")
        zText = QtGui.QApplication.translate("QSphere","Export in XML ISO 19139 current sheet QSphere ...", None, QtGui.QApplication.UnicodeUTF8)
        self.exportISO = QAction(QIcon(menuIcon), zText, self)
        contextMnu_XML.addAction(self.exportISO)
        QObject.connect(self.exportISO,SIGNAL("triggered()"),self.saveXMLIso)

        contextMnu_XML.addSeparator()
        
        menuIcon = getThemeIcon("exportcat.png")
        zText = QtGui.QApplication.translate("QSphere","Export in XML Fields Map for current sheet QSphere ...", None, QtGui.QApplication.UnicodeUTF8)
        self.exportCat = QAction(QIcon(menuIcon), zText, self)
        contextMnu_XML.addAction(self.exportCat)
        QObject.connect(self.exportCat,SIGNAL("triggered()"),self.saveXMLCat)

        self.XMLButton.setMenu(contextMnu_XML)

    def fixeONGLETL(self):
        self.listeOnglets.setCurrentIndex(self.listWidget.currentRow())
        self.tabWidget.setCurrentIndex(self.listWidget.currentRow())
        
    def fixeONGLET(self):
        self.listeOnglets.setCurrentIndex(self.tabWidget.currentIndex())
        self.listWidget.setCurrentRow(self.tabWidget.currentIndex())

    def fixeTAB(self):
        self.tabWidget.setCurrentIndex(self.listeOnglets.currentIndex())
        self.listWidget.setCurrentRow(self.listeOnglets.currentIndex())

    def fixeTABPLUS(self):
        if self.tabWidget.currentIndex() < (self.tabWidget.count()-1) :
           self.tabWidget.setCurrentIndex(self.tabWidget.currentIndex()+1)
           self.listeOnglets.setCurrentIndex(self.tabWidget.currentIndex())

    def fixeTABMOINS(self):
        if self.tabWidget.currentIndex() > 0 :
           self.tabWidget.setCurrentIndex(self.tabWidget.currentIndex()-1)
           self.listeOnglets.setCurrentIndex(self.tabWidget.currentIndex())

    def GetHelpFile(self):
        zLang = "fr" if self.langueTR == "fr" else "en"
        zUrl = "file:helpIHM_"+ zLang +".html"
        d = doUI.DialogViewer(self.iface, zUrl, False, [])
        d.exec_()

    def GetMetaData(self):
        zCRS, zLATN, zLATS, zLONO, zLONE = "EPSG:4326", 51.9, 41.36, -5.79, 9.56
        zCoherence = "{'TopologyLevelCode':'unknow', 'GeometricObjectTypeCode':'unknow'}"
        zIndex = self.tabWidget.currentIndex()

        zObjDico = getWidget(self, "tabledico")
        zObjDico.clearContents()
        while zObjDico.rowCount()> 0 : zObjDico.removeRow(0)
        
        if self.ComboLayers.currentIndex() > 0 :
           zLayer = GetLayerCombo(self, self.modelLayers, self.ComboLayers, True)
           if not zLayer : return            

           zTypoTopology = {QGis.Point: "{'TopologyLevelCode':'geometryOnly', 'GeometricObjectTypeCode':'point'}", QGis.Line : "{'TopologyLevelCode':'topology1D', 'GeometricObjectTypeCode':'curve'}", QGis.Polygon : "{'TopologyLevelCode':'abstract', 'GeometricObjectTypeCode':'surface'}"}
           zkey = zLayer.geometryType() 
           if zTypoTopology.has_key(zkey): zCoherence = zTypoTopology[zkey]
           
           zExtent = zLayer.extent()
           zTransform = DefzTransform(zLayer, 4326)

           MyPoint = zTransform.transform(QgsPoint(zExtent.xMinimum(), zExtent.yMaximum()))
           zLONO, zLATN = MyPoint.x(), MyPoint.y()

           MyPoint = zTransform.transform(QgsPoint(zExtent.xMaximum(), zExtent.yMinimum()))                                          
           zLONE, zLATS = MyPoint.x(), MyPoint.y()

           if IsCorrectLayer(zLayer, True) and zObjDico :
               zProvider = zLayer.dataProvider()
               zFields = zProvider.fields()
               i = 0
               DicoModel = QStandardItemModel()
               for j in range(len(zFields)):
                   zItemId = QTableWidgetItem()
                   zItemName = QTableWidgetItem()
                   zItemTypeName = QTableWidgetItem()
                   zItemLength = QTableWidgetItem()
                   zItemPrecision = QTableWidgetItem()
                   zItemComment = QTableWidgetItem()
                                     
                   zObjDico.insertRow(i)
                   
                   zItemId.setText("%s" % (i))
                   zObjDico.setItem(i,0,zItemId)
                   zObjDico.item( i, 0 ).setFlags(Qt.ItemIsSelectable|Qt.ItemIsEnabled)
                   
                   zItemName.setText("%s" % (zFields[j].name()))
                   zObjDico.setItem(i,1,zItemName)
                   zObjDico.item( i, 1 ).setFlags(Qt.ItemIsSelectable|Qt.ItemIsEnabled)
                   
                   zItemTypeName.setText("%s" %(zFields[j].typeName()))
                   zObjDico.setItem(i,2,zItemTypeName)
                   zObjDico.item( i, 2 ).setFlags(Qt.ItemIsSelectable|Qt.ItemIsEnabled)
                   
                   zItemLength.setText("%s" %(zFields[j].length()))
                   zObjDico.setItem(i,3,zItemLength)
                   zObjDico.item( i, 3 ).setFlags(Qt.ItemIsSelectable|Qt.ItemIsEnabled)
                   
                   zItemPrecision.setText("%s" %(zFields[j].precision()))
                   zObjDico.setItem(i,4,zItemPrecision)
                   zObjDico.item( i, 4 ).setFlags(Qt.ItemIsSelectable|Qt.ItemIsEnabled)
                   
                   zItemComment.setText("%s" %(zFields[j].comment()))
                   zObjDico.setItem(i,5,zItemComment)
                   zObjDico.item( i, 5 ).setFlags(Qt.ItemIsSelectable|Qt.ItemIsEnabled)

                   i+= 1


           zObj = getWidget(self, "tableemprises")
           if zObj :
                zIndexEmp = GetIndex(zObj)
           
                zItem = zObj.cellWidget(zIndexEmp,2)
                if zItem == None : return
                zItem.setValue(zLONO)
                XposD = int(zItem.value())+180

                zItem = zObj.cellWidget(zIndexEmp,3)
                zItem.setValue(zLONE)
                XposF = int(zItem.value())+180
                   
                zItem = zObj.cellWidget(zIndexEmp,0)
                zItem.setValue(zLATN)
                YposD = 90-int(zItem.value())

                zItem = zObj.cellWidget(zIndexEmp,1)
                zItem.setValue(zLATS)
                YposF = 90-int(zItem.value())

           SetTextWidget(self, "namelayer", zLayer.name(), False)
           SetTextWidget(self, "typelayer", FixeLayerType(self, zLayer.type()), False)
           SetTextWidget(self, "metadata", zLayer.metadata(), False)
           SetTextWidget(self, "scr", zLayer.crs().authid(), False)
           SetTextWidget(self, "coherence", zCoherence, False)

        self.listeOnglets.setCurrentIndex(zIndex)
        return

    def AddLine(self):
        zObjectName = "%s" % (self.sender().accessibleName())
        zSplit = zObjectName.split("_")
        zType = int(zSplit[1])
        zCible = zSplit[2]
        zObj = getWidget(self, zCible)
        if zObj == None : return
        if zType == 6 : self.MakeLine(zObj, True, False)
        elif zType == 8:
            zObject = zObj.children()[2]
            zRow = zObject.rowCount()
            zObject.insertRow(zRow)
            AddLineWidget(self, zObject, zRow,  0, 4, 0, -1)
        if zType == 6 :
           self.countItems(zCible, zObj)
           zObj.selectRow(zObj.rowCount()-1)
        elif zType == 8:
           self.countItems(zCible, zObject)
           zObject.selectRow(zObj.rowCount()-1) 
        zObj.setFocus()
           
    def MakeLine(self, zObj, zDrawResult, zReinit):
        zRow = zObj.rowCount()
        if zObj.accessibleName() == "tablescr" :
           zObj.insertRow(zRow) 
           AddLineWidget(self, zObj, zRow,  0, 0, 3, "4258")
           AddLineWidget(self, zObj, zRow,  1, 1, -1, "")
        elif zObj.accessibleName() == "tableformats" :
           zObj.insertRow(zRow) 
           AddLineWidget(self, zObj, zRow,  0, 0, 6, "") 
           AddLineWidget(self, zObj, zRow,  1, 1, -1, "")
           AddLineWidget(self, zObj, zRow,  2, -1, 0, "") 
        elif zObj.accessibleName() == "tableroles" :
           zObj.insertRow(zRow)
           zValue = 2 if zReinit else 6
           if zRow > 1 : zValue = 1
           AddLineWidget(self, zObj, zRow,  0, 2, 0, zValue)
           AddLineWidget(self, zObj, zRow,  1, -1, 0, "")
           AddLineWidget(self, zObj, zRow,  2, -1, 0, "")
           AddLineWidget(self, zObj, zRow,  3, 2, 5, self.indexCountry)
           AddLineWidget(self, zObj, zRow,  4, 0, 2, "")
           AddLineWidget(self, zObj, zRow,  5, -1, 0, "")
           AddLineWidget(self, zObj, zRow,  6, 0, 0, "")
           if zReinit :
              zRow = zObj.rowCount()
              zObj.insertRow(zRow)
              AddLineWidget(self, zObj, zRow,  0, 2, 0, 6)
              AddLineWidget(self, zObj, zRow,  1, -1, 0, "")
              AddLineWidget(self, zObj, zRow,  2, -1, 0, "")
              AddLineWidget(self, zObj, zRow,  3, 2, 5, self.indexCountry)              
              AddLineWidget(self, zObj, zRow,  4, 0, 2, "")
              AddLineWidget(self, zObj, zRow,  5, -1, 0, "")
              AddLineWidget(self, zObj, zRow,  6, 0, 0, "")               
        elif zObj.accessibleName() == "tablelocalisator" :
           zObj.insertRow(zRow) 
           AddLineWidget(self, zObj, zRow,  0, 0, 4, "") 
           AddLineWidget(self, zObj, zRow,  1, -1, 0, "")
        elif zObj.accessibleName() == "tableemprises" :
           zObj.insertRow(zRow) 
           for i in range(4): AddLineWidget(self, zObj, zRow,  i, 3, 0, -1)
           AddLineWidget(self, zObj, zRow,  4, 5, 0, "")
           zObj.setToolTip("%s" % (zRow))
           if zDrawResult : self.DessCadre()
        elif zObj.accessibleName() == "tableetenduetemporelle":
           if not zReinit : 
               zObj.insertRow(zRow) 
               AddLineWidget(self, zObj, zRow,  0, 0, 1, "")
        elif zObj.accessibleName() == "tabledatepubdata":
           zObj.insertRow(zRow) 
           AddLineWidget(self, zObj, zRow,  0, 0, 5, "")
        elif zObj.accessibleName() == "tablemotsclefso" :
           if not zReinit :
               zObj.insertRow(zRow)
               AddLineWidget(self, zObj, zRow,  0, 2, 1, 0)
               AddLineWidget(self, zObj, zRow,  1, 2, -1, (0,0))
        elif zObj.accessibleName() == "tablemotsclefsf" :
           if not zReinit :
               zObj.insertRow(zRow)
               AddLineWidget(self, zObj, zRow,  0, -1, 0, "")
               AddLineWidget(self, zObj, zRow,  1, 6, 0, "")
               AddLineWidget(self, zObj, zRow,  2, -1, 0, "")
               AddLineWidget(self, zObj, zRow,  3, 0, 5, "")
               AddLineWidget(self, zObj, zRow,  4, 2, 2, 0)
        elif zObj.accessibleName() == "tablespecifications" :
           if not zReinit : 
               zObj.insertRow(zRow)
               AddLineWidget(self, zObj, zRow,  0, -1, 0, "")
               AddLineWidget(self, zObj, zRow,  1, 0, 5, "")
               AddLineWidget(self, zObj, zRow,  2, 2, 2, 0)
               AddLineWidget(self, zObj, zRow,  3, 2, 3, 0)
           if zReinit : 
              for i in range(len(self.ListOfConformities)):
                  zObj.insertRow(zRow)
                  AddLineWidget(self, zObj, zRow,  0, -1, 0, "")
                  AddLineWidget(self, zObj, zRow,  1, 0, 5, "")
                  AddLineWidget(self, zObj, zRow,  2, 2, 2, 0)
                  AddLineWidget(self, zObj, zRow,  3, 2, 3, 0)
                  for j in range(4):
                      zItemEditLine = zObj.cellWidget(zRow, j)
                      if zItemEditLine.metaObject().className() in ("QLineEdit", "MySimpleWidgetLineEdit", "MyWidgetLineEdit"): zItemEditLine.setText(self.ListOfConformities[i][j])
                      elif zItemEditLine.metaObject().className() == "QComboBox":
                          try : zItemEditLine.setCurrentIndex(int(self.ListOfConformities[i][j]))
                          except : zItemEditLine.setCurrentIndex(0)
        elif zObj.accessibleName() == "tableechelles" :
              zObj.insertRow(zRow) 
              AddLineWidget(self, zObj, 0,  0, 4, 0, -1)
        self.countItems(zObj.accessibleName(), zObj)              


    def DelLine(self):
        zObject = "%s" % (self.sender().accessibleName())
        self.DelLineProcess(zObject)

    def DelLineProcess(self, zObject):
        if zObject == "" : return
        zSplit = zObject.split("_")
        zType = int(zSplit[1])
        zCible = zSplit[2]
        zObj = getWidget(self, zCible)
        zTitle = "Information"

        if zObj == None : return
        
        if zType !=8 :      
            if zObj.rowCount()==0 :
               zMsg = QtGui.QApplication.translate("QSphere","Nothing to delete.", None, QtGui.QApplication.UnicodeUTF8)
               SendMessage(self, zTitle , zMsg, QgsMessageBar.WARNING, 5)
               return

        if zCible == "tableroles" :
           zMinRow, zMsg = 2, QtGui.QApplication.translate("QSphere","Two reference information must be defined !", None, QtGui.QApplication.UnicodeUTF8) 
        else :
           if zCible in("tablemotsclefso", "tablemotsclefsf", "tableetenduetemporelle", "tablespecifications", "tableformats") : zMinRow, zMsg = 0, QtGui.QApplication.translate("QSphere","Information must be set at least !", None, QtGui.QApplication.UnicodeUTF8)
           else : zMinRow, zMsg = 1, QtGui.QApplication.translate("QSphere","Information must be set at least !", None, QtGui.QApplication.UnicodeUTF8)
        
        if zType == 8: zObj = zObj.children()[2]
        if zObj.rowCount() > zMinRow :
            zObj.removeRow(zObj.rowCount()-1)
            if zCible == "tableemprises":
               zObj.setToolTip("%s" % (zObj.rowCount()-1))
               self.DessCadre()
        else:
            zMsg = QtGui.QApplication.translate("QSphere","Can not delete the last line.\n", None, QtGui.QApplication.UnicodeUTF8)+zMsg
            SendMessage(self, zTitle , zMsg, QgsMessageBar.WARNING, 5)
        self.countItems(zCible, zObj)
        zObj.selectRow(zObj.rowCount()-1)
        zObj.setFocus()

    def saveXMLCat(self):
        zObj = getWidget(self,"tabledico")
        zTitle = "Information"
        if zObj.rowCount()==0 :
            zMsg =  QtGui.QApplication.translate("QSphere","No information for fields map.", None, QtGui.QApplication.UnicodeUTF8)
            zObj.setFocus()
            SendMessage(self, zTitle , "%s" % (zMsg), QgsMessageBar.WARNING, 2)
            return
        InitDir = os.path.dirname(__file__) if self.initDir == "" else self.initDir 
        fileName = QFileDialog.getSaveFileName(None, QtGui.QApplication.translate("QSphere","Export Fields Map from QSphere record in XML", None, QtGui.QApplication.UnicodeUTF8),InitDir,"*.xml") 
        if fileName!="":
           ExportCatToXML(self, fileName)
           zMsg =  QtGui.QApplication.translate("QSphere","The Field Map was exported as :\n", None, QtGui.QApplication.UnicodeUTF8) 
           SendMessage(self, zTitle , "%s%s" % (zMsg, fileName), QgsMessageBar.INFO, 5)
           
    def saveXMLIso(self):
        InitDir = os.path.dirname(__file__) if self.initDir == "" else self.initDir 
        fileName = QFileDialog.getSaveFileName(None, QtGui.QApplication.translate("QSphere","Export QSphere record in XML iso 19139", None, QtGui.QApplication.UnicodeUTF8),InitDir,"*.xml") 
        if fileName!="": 
           ExportToXML(self, fileName)
           zTitle = "Information"
           zMsg =  QtGui.QApplication.translate("QSphere","The metadata record was exported as :\n", None, QtGui.QApplication.UnicodeUTF8)
           SendMessage(self, zTitle , "%s%s" % (zMsg, fileName), QgsMessageBar.INFO, 5)

           d = doUI.DialogViewer(self.iface, "filexml:%s" % (fileName), True, []) 
           d.exec_()

    def reinitDateMDD(self, zObj):
        zDate = "%s" % (datetime.datetime.now())
        zDate = zDate.split(" ")[0]
        zEltsDate = zDate.split("-")
        zObj.setSelectedDate(QDate(int(zEltsDate[0]), int(zEltsDate[1]), int(zEltsDate[2])))

    def NewSheet(self):
        self.setWindowTitle(self.racWindowTitle)
        zIndex = self.tabWidget.currentIndex()
        zTabs = self.tabWidget.count()
        zObj = None

        mylang = QtCore.QLocale.languageToString( self.langue )
        for key in self.languesDico.keys():
            if self.languesDico[key]['english'] == mylang :
               mycodelang = self.languesDico[key]['bibliographic']
               break
        
        for i in range(zTabs):
            self.tabWidget.setCurrentIndex(i)
            zTab = self.tabWidget.currentWidget()
            zObjs = zTab.children()
            for j in range(len(zObjs)):
                zObj = zObjs[j]
                zClassObjName = "%s" % (zObj.metaObject().className())

                if zClassObjName=="MyButton" : pass
                elif zClassObjName=="QCalendarWidget" : self.reinitDateMDD(zObj)

                elif zClassObjName=="QTextEdit" :
                    if zObj.isEnabled(): zObj.setPlainText("")
                    else :
                        if zObj.accessibleName()== "coherence" : zObj.setPlainText("{'TopologyLevelCode':'unknow', 'GeometricObjectTypeCode':'unknow'}")
                    if zObj.accessibleName() == "licence" : zObj.setPlainText("%s" % (QtGui.QApplication.translate("QSphere","Open Licence", None, QtGui.QApplication.UnicodeUTF8)))
                elif zClassObjName in ("QLineEdit", "MySimpleWidgetLineEdit", "MyWidgetLineEdit") :
                    zObj.setText("") if zObj.accessibleName() != "identificator" else zObj.setText("%s-%s-%s" % (self.langueTR.upper(), datetime.datetime.now().year, getRandowId(self)))
                elif zClassObjName=="QComboBox" :
                    iIndex = 0
                    zObj.clear()
                    if zObj.accessibleName() == "typedata" : zObj.insertItems(0, self.listTypeRessources)
                    elif zObj.accessibleName()== "sysreftemp" :
                       zObj.insertItems(0, self.listTemporalSystem)
                       iIndex = 1
                    elif zObj.accessibleName()== "tablecarac" :
                       zObj.insertItems(0, self.listCodecs)
                       iIndex = self.listCodecs.index("utf8")
                    elif zObj.accessibleName()== "langmetada" :
                       iIndex = MakeListLangues(self, zObj, mylang)
                    zObj.setCurrentIndex(iIndex)

                elif zClassObjName=="QGroupBox" :
                    zChildren = zObj.children()
                    zChildren[0].setChecked(True)
                    zTable = zChildren[2]
                    if zTable.metaObject().className() == "QTableWidget" :
                        zTable.clearContents()
                        for j in range(zTable.rowCount()): zTable.removeRow(0)
                        self.MakeLine(zTable, False, True)
                    elif zTable.metaObject().className() == "QTableView" :
                        zLang = "fr" if self.langueTR == "fr" else "en"
                        SizezSubObjH, zCols, iLine = LoadFile(self, zTable, zTable.accessibleName(), "file:280:contraintes_%s.csv:1:0" % (zLang), 3, self.tableModel)
                        
                    if len(zChildren) > 3 :    
                        zCombo = zChildren[3]
                        zCombo.setCurrentIndex(0)
    
                elif zClassObjName=="QTableView" :
                     if zObj.objectName() == "tablelangues" :
                            for i in range(len(self.langs)):
                                zItem = zObj.model().item(i, 0)
                                language = self.langs[i]
                   
                     for k in range(zObj.model().rowCount()):
                         zItem = zObj.model().item(k, 0)
                         zItem.setCheckState(Qt.Unchecked)
                         if zObj.objectName() == "tablelangues" and zItem.text().startswith(self.langueTR): zItem.setCheckState(Qt.Checked)

                elif zClassObjName=="QTableWidget" :
                    zObj.clearContents()
                    for j in range(zObj.rowCount()): zObj.removeRow(0)
                    self.MakeLine(zObj, False, True)
                    if zObj.objectName() == "tableemprises" : self.DessCadre()
                    
        self.CountLangues()
        self.listeOnglets.setCurrentIndex(zIndex)
        

    def SaveAsDataQSP(self):
        InitDir = os.path.dirname(__file__) if self.initDir == "" else self.initDir 
        fileName = QFileDialog.getSaveFileName(None, QtGui.QApplication.translate("QSphere","Save as a file QSPHERE", None, QtGui.QApplication.UnicodeUTF8),InitDir,"*.qsp")
        self.MakeSaveQSP(fileName, False)
           
    def SaveDataQSP(self):
        if self.windowTitle() != self.racWindowTitle :
            fileName = self.windowTitle().replace(self.racWindowTitle, "")
            self.MakeSaveQSP(fileName, True)
        else : self.SaveAsDataQSP()    

    def MakeSaveQSP(self, fileName, zSendMsg):
           if fileName=="":
               zTitle = "Error"
               zMsg =  QtGui.QApplication.translate("QSphere","No File destination to record the metadata !", None, QtGui.QApplication.UnicodeUTF8)
               UseCase = QgsMessageBar.WARNING
               if zSendMsg : SendMessage(self, zTitle , zMsg, UseCase, 5)
           else :    
               SaveQSP(self, fileName)
               zTitle = "Information"
               zMsg =  QtGui.QApplication.translate("QSphere","The metadata record was exported as :\n", None, QtGui.QApplication.UnicodeUTF8)
               UseCase = QgsMessageBar.INFO
               SendMessage(self, zTitle , "%s%s" % (zMsg, fileName), UseCase, 5)
           if fileName!="": self.initDir = os.path.dirname(fileName)    

    def ViewDataFromXML(self):
        InitDir = os.path.dirname(__file__) if self.initDir == "" else self.initDir
        fileName = QFileDialog.getOpenFileName(None, QtGui.QApplication.translate("QSphere","View a file XML ISO 19139", None, QtGui.QApplication.UnicodeUTF8),InitDir,"*.xml")
        if fileName!="" :
           d = doUI.DialogViewer(self.iface, "filexml:%s" % (fileName), True, []) 
           d.exec_()
         
    def LoadDataFromXML(self):
        zIndex = self.tabWidget.currentIndex()
        import xml.etree.ElementTree as ET
        InitDir = os.path.dirname(__file__) if self.initDir == "" else self.initDir
        fileName = QFileDialog.getOpenFileName(None, QtGui.QApplication.translate("QSphere","Load a file XML ISO 19139", None, QtGui.QApplication.UnicodeUTF8),InitDir,"*.xml")
        if fileName!="" :

            self.NewSheet()
            
            tree = ET.parse(fileName)
            root = tree.getroot()
            if root.tag != '{http://www.isotc211.org/2005/gmd}MD_Metadata':
               zMsg = QtGui.QApplication.translate("QSphere","XML document does not appear to be ISO (not gmd:MD_Metadata found) !", None, QtGui.QApplication.UnicodeUTF8)
               SendMessage(self, "information" , zMsg, QgsMessageBar.WARNING, 5) 
               return
            
            from xmlISOparser import *
            self.listImportCategories = []
            myISO = xmlISOparser(fileName, None, 'MEDDE', self.langueTR) 
            myISO.createISOdataStructure()
            
            zorderkeys = ("intitule", "resume", "typedata", "tablelocalisator", "identificator", "tablelangues", "tableformats", "tablecarac", \
                          "tablecategories", "tablemotsclefsf", "tablescr", "tableemprises", "tableetenduetemporelle", "groups:dates", \
                          "genealogie", "coherence", "grouperesolutionscale", "tablespecifications", "groupedroits", "licence", "tableroles:1", "tableroles:2", "tableroles:3", \
                          "datemetada", "langmetada")
            
            zWidgetValues = {"intitule": myISO.title , "resume" : myISO.abstract, "typedata": myISO.typedata, "tablelocalisator" : myISO.localisators, \
                             "identificator" : myISO.fileIdentifier, "tablelangues" : myISO.languesjdd, "tableformats" : myISO.formatsjdd, "tablecarac": myISO.tablecarac,  \
                             "tablecategories" : myISO.categories, "tablemotsclefsf" : myISO.keywordsF, \
                             "tablescr" : myISO.scr, "tableemprises" : myISO.boundingboxcoordinates, \
                             "tableetenduetemporelle" : myISO.timeperiodes, "groups:dates" : myISO.dates, \
                             "genealogie" : myISO.genealogie, "coherence" : myISO.coherence, "grouperesolutionscale" : myISO.scalesEC, \
                             "tablespecifications": myISO.conformities, "groupedroits" : myISO.accessconstraints, "licence" : myISO.legalconstraints, \
                             "tableroles:1" : myISO.pointsofcontactMDD, "tableroles:2" : myISO.pointsofcontact, "tableroles:3" : myISO.pointsofcontactCust, \
                             "datemetada" : (myISO.datemdd, myISO.datetmdd ), "langmetada" : myISO.languemdd
                             }

            self.tabWidget.setVisible(False)
            self.progressBar.setVisible(True)
            zBounds, i = len(zorderkeys), 0
            for i in range(zBounds):
                key = zorderkeys[i]
                self.UpdateWidget(key, zWidgetValues[key], myISO)
                self.progressBar.setValue(int(100 * i/zBounds))
                i+= 1
            self.initDir = os.path.dirname(fileName)

        self.CountLangues()        
        self.listeOnglets.setCurrentIndex(zIndex)
        self.progressBar.setValue(0)
        self.tabWidget.setVisible(True)
        self.progressBar.setVisible(False)

    def UpdateWidget(self, zkeyWidget, zIsoXML, myISO):
        if not (zIsoXML) : return
        
        if zkeyWidget.startswith("groups:"):
           zGroupTarget = zkeyWidget.split(":")[1]
           zGroups = {"dates": {"c" : "datecredata", "r" : "daterevdata", "p" : "tabledatepubdata"}}
           zGroup = zGroups[zGroupTarget]

           if zGroupTarget == "dates" :
               zObj = getWidget(self, "tabledatepubdata")
               self.cleanAllObj(zObj, True)
               i=0
               for elt in zIsoXML :
                   if type(elt) == dict :
                       #TOTO 2.6.1
                       if elt.has_key('type'): return
                       if elt['type'] == "" : return
                       #TOTO 2.6.1
                       zType = elt['type'][0:1]
                       zObj = getWidget(self, zGroup[zType])
                       if zType in ("c", "r") : 
                           zEltsDate = elt['date'].split("-")
                           zObj.setSelectedDate(QDate(int(zEltsDate[0]), int(zEltsDate[1]), int(zEltsDate[2]) ))
                       elif zType == "p" :
                            self.MakeLine(zObj, True, False)
                            zObj.cellWidget(i, 0).setText(elt['date'])
                            i+= 1
        elif zkeyWidget == "coherence" : self.UpdateCoherence(zkeyWidget, zIsoXML)                     
        elif zkeyWidget == "tablespecifications" : self.UpdateTableSpecifications(zkeyWidget, zIsoXML)                    
        elif zkeyWidget == "tablemotsclefsf" : self.UpdateTableKeywordsF(zkeyWidget, zIsoXML, myISO)
        elif zkeyWidget == "tableetenduetemporelle": self.UpdateEtenduesTemporelles(zkeyWidget, zIsoXML, myISO)
        elif zkeyWidget == "groupedroits": self.UpdateEtenduesRights(zkeyWidget, zIsoXML, myISO)
        elif zkeyWidget.find("tableroles:")!=-1 : self.UpdateTableRoles(zkeyWidget, zIsoXML)
        elif zkeyWidget == "grouperesolutionscale":
            if (myISO.scalesEC[0]==[]) and (myISO.scalesUM[0]==[]): return
            zObj = getWidget(self, zkeyWidget)
            zChildren = zObj.children()

            if (myISO.scalesUM[0]!=[]) :
                zChildren[1].setChecked(True)
                zInfos = myISO.scalesUM[0]
                try : zUnits = myISO.UnitsScalesUM[0][0]['uom']
                except : zUnits = "m" 
                zChildren[3].setEnabled(True)
                zIndex = self.ListUnitsMesure.index(zUnits) if zUnits in (self.ListUnitsMesure) else 0
                zChildren[3].setCurrentIndex(zIndex) 
            else :
                zChildren[0].setChecked(True)
                zInfos = myISO.scalesEC[0]
                zChildren[3].setEnabled(False)

            zChildren[2].clearContents()
            for j in range(zChildren[2].rowCount()): zChildren[2].removeRow(0)
            for j in range(len(zInfos)):
                zChildren[2].insertRow(j)
                zValue = float(zInfos[j]) if convertSTR(zInfos[j], "float") else 0.0
                AddLineWidget(self, zChildren[2], j,  0, 4, 0, zValue)
     
        else :
            zObj = getWidget(self, zkeyWidget)
            if zObj.metaObject().className() == "QLineEdit" :
                if (zIsoXML[0])!= []: zObj.setText(zIsoXML[0][0])
                
            elif zObj.metaObject().className() == "QCalendarWidget" :
                 zDate = ""
                 for elt in zIsoXML :
                     if elt[0]!=[] : zDate = elt[0][0]
                     
                 if zDate != "":
                     sep = ""    
                     if zDate.find("T")!=-1 : sep = "T" 
                     elif zDate.find(" ")!=-1 : sep = " "
                     if sep!="" : zDate = zDate.split(sep)[0] 
                     zEltsDate = zDate.split("-")
                     try : zObj.setSelectedDate(QDate(int(zEltsDate[0]), int(zEltsDate[1]), int(zEltsDate[2])))
                     except : self.reinitDateMDD(zObj)
             
            elif zObj.metaObject().className() == "QTextEdit" :
                if (zIsoXML[0])!= []: zObj.setPlainText(zIsoXML[0][0])
                
            elif zObj.metaObject().className() == "QTableView" :
                   if zObj.accessibleName() == "tablecategories": refcol, zIsoXML[0] = 1, [item.capitalize() for item in zIsoXML[0]]
                   elif zObj.accessibleName() == "tablelangues": refcol, zIsoXML[0] = 0, [item.lower() for item in zIsoXML[0]]
                   else : refcol = 0
                   for i in range(zObj.model().rowCount()):
                       if zObj.model().item(i, refcol).text() in zIsoXML[0]:
                          zObj.model().item(i, 0).setCheckState(Qt.Checked)
                          self.listImportCategories.append(zObj.model().item(i, refcol).text())
                       else : zObj.model().item(i, 0).setCheckState(Qt.Unchecked)
                       
            elif zObj.metaObject().className() == "QComboBox" :
                 #TOTO 2.6.1
                 try : zValue = zIsoXML[0][0]
                 except : zValue = zIsoXML[0]
                 if zValue == [] : return
                 #TOTO 2.6.1
                 if zObj.accessibleName() == "tablecarac" :
                     if zValue != None :
                         if zValue.find("MD_CharacterSetCode_")!=-1: zValue = zValue.replace("MD_CharacterSetCode_","")
                     else : zValue == "None"    
                     zIndex = self.listCodecs.index(zValue) if zValue in (self.listCodecs) else 0
                     zObj.setCurrentIndex(zIndex)
                 if zObj.accessibleName() == "typedata" :
                     zIndex = self.listTypeRessources.index(zValue) if zValue in (self.listTypeRessources) else 0
                     zObj.setCurrentIndex(zIndex)
                     
            elif zObj.metaObject().className() == "QTableWidget" :
                 self.cleanAllObj(zObj, True)
                 zRows = len(zIsoXML)
                 if zObj.accessibleName() == "tablescr" :zRows = len(zIsoXML[0])
                 for i in range(zRows):
                     if zObj.accessibleName() == "tableemprises":
                         if type(zIsoXML[i])==dict:
                             self.MakeLine(zObj, True, False)
                             zObj.cellWidget(i, 0).setValue(float(zIsoXML[i]['north']))
                             zObj.cellWidget(i, 1).setValue(float(zIsoXML[i]['south']))
                             zObj.cellWidget(i, 2).setValue(float(zIsoXML[i]['west']))
                             zObj.cellWidget(i, 3).setValue(float(zIsoXML[i]['east']))
                     elif  zObj.accessibleName() == "tableformats":
                         if type(zIsoXML[i])==dict:
                             self.MakeLine(zObj, True, False)
                             zObj.cellWidget(i, 0).setText("%s" % (zIsoXML[i]['name']))
                             zObj.cellWidget(i, 2).setText("%s" % (zIsoXML[i]['version']))
                         elif type(zIsoXML[i])== list :
                             self.UpdateTableFormats(zObj, zIsoXML[i])
                             return
                     elif zObj.accessibleName() == "tablelocalisator" :
                         if type(zIsoXML[i])== dict :
                             self.MakeLine(zObj, True, False)
                             zObj.cellWidget(i, 0).setText("%s" % (zIsoXML[i]['url']))
                             zObj.cellWidget(i, 1).setText("%s" % (zIsoXML[i]['name']))
                         else :
                             self.MakeLine(zObj, True, False)
                             try : zObj.cellWidget(i, 0).setText("%s" % (zIsoXML[0][i]))
                             except : pass
                     elif zObj.accessibleName() == "tablescr" :
                         self.MakeLine(zObj, True, False)
                         zObj.cellWidget(i, 0).setText("%s" % (zIsoXML[0][i]))

                 if zObj.accessibleName() == "tableemprises":
                    zObj.setToolTip("%s" % (zObj.rowCount()-1))
                    self.DessCadre()

    def UpdateTableFormats(self, zObj, zList):
        for k in range(len(zList)):
            self.MakeLine(zObj, True, False)
            zObj.cellWidget(k, 0).setText("%s" % (zList[k]))

    def UpdateCoherence(self, zkeyWidget, zIsoXML):
        zObj = getWidget(self, zkeyWidget)
        import ast
        try : mydict = ast.literal_eval("%s" % (zIsoXML))
        except : mydict = None
       
        if mydict!= None :
           if type(mydict)== dict :
               if mydict.has_key('TopologyLevelCode') and mydict.has_key('GeometricObjectTypeCode'): zObj.setPlainText("{'TopologyLevelCode':'%s', 'GeometricObjectTypeCode':'%s'}" % (mydict['TopologyLevelCode'],mydict['GeometricObjectTypeCode']))
               else : zObj.setPlainText("{'TopologyLevelCode':'unknow', 'GeometricObjectTypeCode':'unknow'}")
           elif type(mydict)== list :
               if len(mydict)== 2 and type(mydict[0])==list and type(mydict[1])==list:
                  try : zTopologyLevelCode = mydict[0][0]
                  except : zTopologyLevelCode = 'unknow'
                  try : zGeometricObjectTypeCode = mydict[1][0]
                  except: zGeometricObjectTypeCode = 'unknow'
                  zObj.setPlainText("{'TopologyLevelCode':'%s', 'GeometricObjectTypeCode':'%s'}" % (zTopologyLevelCode, zGeometricObjectTypeCode)) 
               else : zObj.setPlainText("{'TopologyLevelCode':'unknow', 'GeometricObjectTypeCode':'unknow'}")
        else : zObj.setPlainText("{'TopologyLevelCode':'unknow', 'GeometricObjectTypeCode':'unknow'}")
        

    def UpdateEtenduesRights(self, zkeyWidget, zIsoXML, myISO):
        if type(zIsoXML[0])==list:
            if zIsoXML[0]==[]: return
            if zIsoXML[0][0] == "otherRestrictions" : #or != ""
                counter=0
                zObj = getWidget(self, zkeyWidget)
                zConstraints = myISO.otherconstraints[0]
                zChild = zObj.children()[2]
                zModel = zChild.model()
                for j in range(len(zConstraints)):
                    zCond, zIndex = self.isContraintsIn(zConstraints[j], zModel)
                    if zCond :
                       zChild.model().item(zIndex, 0).setCheckState(Qt.Checked)
                       counter+= 1
                if counter > 0 : zObj.children()[1].setChecked(True)

    def isContraintsIn(self, zContraintText, zModel):
        zCond, zIndex = False, -1
        #First, check the model ...
        for i in range(zModel.rowCount()):
            if zContraintText.find(zModel.item(i, 0).text())!=-1 or  zContraintText.find(zModel.item(i, 1).text())!=-1  : return True, i
        #Second test, on list INSPIRE
        listContraints = ("(a) the confidentiality of the proceedings of public authorities, where such confidentiality is provided for by law.", \
                          "(b) international relations, public security or national defence.", \
                          "(c) the course of justice, the ability of any person to receive a fair trial or the ability of a public authority to conduct an enquiry of a criminal or disciplinary nature", \
                          "(d) the confidentiality of commercial or industrial information, where such confidentiality is provided for by national or Community law to protect a legitimate economic interest, including  the  public  interest  in  maintaining  statistical confidentiality and tax secrecy.", \
                          "(e) intellectual property rights", \
                          "(f) the confidentiality of personal data and/or files relating to a natural person where that person has not consented to the disclosure of  the information to the public, where such confidentiality is provided for by national or Community law.", \
                          "(g) the interests or protection of any person who supplied the information requested on a voluntary basis without being under, or capable of being put under, a legal obligation to do so, unless that person has consented to the release of the information concerned.", \
                          "(h) the protection of the environment to which such information relates, such as the location of rare species.")
        for i in range(len(listContraints)):
            if listContraints[i].find(zContraintText)!=-1 or zContraintText.find(listContraints[i])!=-1 : return True, i
        return zCond, zIndex


    def UpdateTableSpecifications(self, zkeyWidget, zIsoXML):
        zDim = len(zIsoXML)
        zObj = getWidget(self, zkeyWidget)
        if not zObj : return
        self.cleanAllObj(zObj, True)
        for i in range(zDim):
            if zIsoXML[i]==[]:pass
            else :
                if type(zIsoXML[i])==dict:
                    self.MakeLine(zObj, True, False)
                    zObj.cellWidget(i, 0).setText(zIsoXML[i]['text'])
                    zObj.cellWidget(i, 1).setText(zIsoXML[i]['date'])
                    zIndex = ("creation","revision","publication").index(zIsoXML[i]['typedate'].lower())
                    if zIndex == -1 : zIndex = 0
                    zObj.cellWidget(i, 2).setCurrentIndex(zIndex)

                    if type(zIsoXML[i]['conformity'])== str :
                       zIndex = 0 if zIsoXML[i]['conformity'].lower() == 'true' else 1 
                    else : zIndex = 2                
                    zObj.cellWidget(i, 3).setCurrentIndex(zIndex)
        

    def UpdateEtenduesTemporelles(self, zkeyWidget, zIsoXML, myISO):
        zObj = getWidget(self, zkeyWidget)
        if not zObj : return
        self.cleanAllObj(zObj, True)
        if type(zIsoXML[0])== dict :
           zDim = len(zIsoXML) 
           for i in range(zDim):
               self.MakeLine(zObj, True, False)
               zLine = zObj.rowCount()-1
               zObj.cellWidget(zLine, 0).setText("%s %s" % (zIsoXML[i]['start'], zIsoXML[i]['end']))
        else :
           if len(zIsoXML[0])>0: 
              for i in range(0, len(zIsoXML[0]), 2):
                   self.MakeLine(zObj, True, False)
                   zLine = zObj.rowCount()-1
                   zObj.cellWidget(zLine, 0).setText("%s %s" % (zIsoXML[0][i], zIsoXML[0][i+1]))


    def UpdateTableKeywordsF(self, zkeyWidget, zIsoXML, myISO):
        zDim = len(zIsoXML)
        zObj = getWidget(self, zkeyWidget)
        if not zObj : return
        
        if zIsoXML == 'None' :
           zIsoXML = myISO.keywordsFNC
           zDim = len(zIsoXML[0])

           for i in range(zDim):
               if type(zIsoXML[0]) == list:
                 if zIsoXML[0][i]!="" and zIsoXML[0][i].capitalize() not in (self.listImportCategories) :
                    self.MakeLine(zObj, True, False)
                    zLine = zObj.rowCount()-1

                    zObj.cellWidget(zLine, 0).setText("%s" % (zIsoXML[0][i]))
                    zObj.cellWidget(zLine, 1).setChecked(False)
                    
                    for k in range(2,5):
                        zItemEditLine = zObj.cellWidget(zLine, k)
                        try : zItemEditLine.setEnabled(False)
                        except : pass

        else :
            zkeys = {'keyword':0,'thesaurus':2,'date':3,'typedate':4}
            for i in range(zDim):
                if type(zIsoXML[i])== dict :
                   if zIsoXML[i]['keyword'].capitalize() not in (self.listImportCategories): 
                       self.MakeLine(zObj, True, False)
                       zLine = zObj.rowCount()-1

                       for key in zIsoXML[i] :
                           ikey = zkeys[key]
                           if zObj.cellWidget(zLine, ikey).metaObject().className() == "QComboBox" :
                              zIndex = ("creation","revision","publication").index(zIsoXML[i][key])
                              if zIndex == -1 : zIndex = 0
                              zObj.cellWidget(zLine, ikey).setCurrentIndex(zIndex)
                           else : zObj.cellWidget(zLine, ikey).setText("%s" % (zIsoXML[i][key]))
                      
              

    def UpdateTableRoles(self, zkeyWidget, zIsoXML):
         zDim = len(zIsoXML)
         zkeyWidget = zkeyWidget.split(":")[0]
         zObj = getWidget(self, zkeyWidget)
         if not zObj : return

         zkeys = {'ville': 5, 'name': 1, 'pays': 3, 'adresse': 2, 'codepostal': 4, 'mail': 6, 'role': 0}
         zinvkeys = {0: 'role', 1: 'name', 2: 'adresse', 3: 'pays', 4 : 'codepostal', 5: 'ville', 6: 'mail'}
         
         for i in range(zDim):
             if type(zIsoXML[i])== dict :
                 if zIsoXML[i]['role'] == None : break
                 if zIsoXML[i]['role'].lower() == "owner" : zLine = 0
                 elif  zIsoXML[i]['role'].lower() == "pointofcontact" : zLine = 1
                 else : 
                      self.MakeLine(zObj, True, False)
                      zLine = zObj.rowCount()-1
                 for key in zIsoXML[i] :
                     ikey = zkeys[key]
                     if zObj.cellWidget(zLine, ikey).metaObject().className() == "QComboBox" :
                         if key == "role":
                             zIndexes = [keyitem for keyitem, value in self.DicoListOfRules.items() if value == zIsoXML[i][key]] 
                             if zIndexes!=[] : zIndex = zIndexes[0]  
                         else : zIndex = zObj.cellWidget(zLine, ikey).findText(zIsoXML[i][key].capitalize())
                         if zIndex == -1 : zIndex = 0
                         zObj.cellWidget(zLine, ikey).setCurrentIndex(zIndex) 
                     else : zObj.cellWidget(zLine, ikey).setText("%s" % (zIsoXML[i][key]))
                     ikey+= 1
                     
             elif type(zIsoXML[i])== list :
                 if zIsoXML[0] == [] : break
                 if zIsoXML[0][0] == None: break
                 if zIsoXML[0][0].lower()=="owner": zLine = 0
                 elif  zIsoXML[0][0].lower() == "pointofcontact" : zLine = 1
                 else : 
                      self.MakeLine(zObj, True, False)
                      zLine = zObj.rowCount()-1
                 for j in range(zDim):
                     if zIsoXML[j]!=[] :
                         if zObj.cellWidget(zLine, j).metaObject().className() == "QComboBox" :
                                 zIndex = 0
                                 if zinvkeys[j] == "role":
                                     zIndexes = [keyitem for keyitem, value in self.DicoListOfRules.items() if value == zIsoXML[j][0]] 
                                     if zIndexes!=[] : zIndex = zIndexes[0]  
                                 else : zIndex = zObj.cellWidget(zLine, j).findText(zIsoXML[j][0].capitalize())
                                 if zIndex == -1 : zIndex = 0
                                 zObj.cellWidget(zLine, j).setCurrentIndex(zIndex)
                         else : zObj.cellWidget(zLine, j).setText("%s" % (zIsoXML[j][0]))
                 break
            
    def loadDataQSP(self):
        InitDir = os.path.dirname(__file__) if self.initDir == "" else self.initDir
        fileName = QFileDialog.getOpenFileName(None, QtGui.QApplication.translate("QSphere","Load a file QSPHERE", None, QtGui.QApplication.UnicodeUTF8),InitDir,"*.qsp") 
        if fileName!="" :
           zIndex = self.tabWidget.currentIndex()
           self.NewSheet()
           LoadQSP(self, fileName)
           self.initDir = os.path.dirname(fileName)
           self.CountLangues()
           self.listeOnglets.setCurrentIndex(zIndex)
           

    def ChangeOptionScale(self):
        zIndex = self.tabWidget.currentIndex()
        self.sender().parent().children()[3].setEnabled(self.sender().parent().children()[1].isChecked())
        if self.sender().parent().children()[0].isChecked():
           ztoolTip = "%s" % (self.sender().parent().children()[0].toolTip())
           cible = 1 
        else :
           ztoolTip = "%s" % (self.sender().parent().children()[1].toolTip()),
           cible = 0 
        valuesObj = None
        if ztoolTip.find("|")!=-1: valuesObj = ztoolTip.split("|")
        else:
            if is_number_float(ztoolTip): valObj = float(ztoolTip)
            else : valObj = 0.0
        
        zObject = self.sender().parent().children()[2] 
        zRow = zObject.rowCount()
        valuesObjsave = ""
        for i in range(zRow):
            Obj = zObject.cellWidget(i, 0)
            #TOTO 2.6.1
            #valuesObjsave+= str(Obj.value()) if valuesObjsave == "" else "|" + str(Obj.value())
            zSepa = "" if valuesObjsave == "" else "|"
            valuesObjsave+= "%s%s" % (zSepa, Obj.value())
            
            if self.sender().parent().children()[0].isChecked(): PropertiesDoubleSpinBox(self, Obj, 0, 0, 10000000, 1000)
            else: PropertiesDoubleSpinBox(self, Obj, 4, 0, 1000, 10)
            
            if valuesObj == None : Obj.setValue(valObj)
            else :
                if i <= (len(valuesObj)-1): Obj.setValue(float(valuesObj[i]))
                else : Obj.setValue(float(valuesObj[len(valuesObj)-1]))

        if valuesObjsave!= "" : self.sender().parent().children()[cible].setToolTip("%s" % (valuesObjsave))
        self.listeOnglets.setCurrentIndex(zIndex)
            
    def ChangeOptionRights(self): self.sender().parent().children()[2].setEnabled(self.sender().parent().children()[1].isChecked())

    def ChangeButtonIcon(self, zButton, zIcon, zSizeWIcon, zSizeHIcon):
        zIcon = getThemeIcon(zIcon)
        zButton.setIcon(QIcon(zIcon))
        zButton.setIconSize(QSize(zSizeWIcon, zSizeHIcon))

    def goToLocalisator(self):
        zObj = getWidget(self, "tablelocalisator")
        if zObj.currentRow()==-1: zObj.selectRow(0)
        zWidget = zObj.cellWidget(zObj.currentRow(),0)
        if zWidget.styleSheet()== "background-color:#AEEE00;" :
           zUrl = zWidget.text()
           d = doUI.DialogViewer(self.iface, zUrl, False, [])
           d.exec_()
        else :
           zTitle = QtGui.QApplication.translate("QSphere", "Warning" , None, QtGui.QApplication.UnicodeUTF8) 
           zMsg = QtGui.QApplication.translate("QSphere"," The URL you entered is incomplete or invalid! Please correct the line : ", None, QtGui.QApplication.UnicodeUTF8)
           try : SendMessage(self, zTitle, "%s%s" % (zMsg, zObj.currentRow()), QgsMessageBar.WARNING, 2)
           except : pass

    def AfficheHelp(self):
        zChange = False
        self.ChangeButtonIcon(self.sender(),"infoactivate.png", 24, 24)   
        zUrl = "%s" % (self.sender().accessibleDescription())
        d = doUI.DialogViewer(self.iface, zUrl, False, [])
        d.exec_()
        self.ChangeButtonIcon(self.sender(),"info.png", 24, 24)

    def AfficheRessources(self):
        zUrl = "%s" % (self.sender().toolTip()) 
        d = doUI.DialogViewer(self.iface, zUrl, False, [])
        d.exec_()

    def CallSelectorConformityInfos(self):
        zObj = getWidget(self, "coherence")
        dialog = TopologyDialog(zObj.toPlainText())
        MakeWindowIcon(dialog, "qsp.png")
        if dialog.exec_(): zObj.setPlainText("%s" % (dialog.infosTopology()))
        
    def CallQgsProjectionSelector(self):
         zObj = getWidget(self, "tablescr")
         zIndex = int(self.sender().accessibleName().split("_")[2])
         zItemEditLine = zObj.cellWidget(zIndex,0)
         dialog = SRSDialog()
         MakeWindowIcon(dialog, "qsp.png")
         dialog.setWindowTitle(QtGui.QApplication.translate("QSphere","Coordinate Reference System Selector", None, QtGui.QApplication.UnicodeUTF8))
         if dialog.exec_(): zItemEditLine.setText("%s" % (dialog.epsg()))
         
    def CallFormatSelector(self):
        zObj = getWidget(self, "tableformats")
        zIndex = int(self.sender().accessibleName().split("_")[2])
        zItemEditLine = zObj.cellWidget(zIndex,0)
        dialog = FormatDialog(self.ListFormats)
        MakeWindowIcon(dialog, "qsp.png")
        if dialog.exec_(): zItemEditLine.setText("%s" % (dialog.format()))

    def CheckInfosRoles(self):
        zObj = self.sender()
        zObjParent = getWidget(self, "tableroles")
        if zObj.currentIndex() in (2,6) and zObjParent.rowCount()>2 :
           zTitle = QtGui.QApplication.translate("QSphere", "Warning" , None, QtGui.QApplication.UnicodeUTF8) 
           zMsg = QtGui.QApplication.translate("QSphere"," One owner or PointOfContact ! Please ...", None, QtGui.QApplication.UnicodeUTF8)
           try : SendMessage(self, zTitle, zMsg, QgsMessageBar.WARNING, 2)
           except : pass
           zObj.setCurrentIndex(1)

    def ChangePatternZipPostalCode(self):
        if self.sender().accessibleName() == "" : return
        zNameObjRac = self.sender().accessibleName().split("_")[0]
        zRowCombo = int(self.sender().accessibleName().split("_")[2])
        zObj = getWidget(self, zNameObjRac)
        if zObj != None :
            zObjWidget = zObj.cellWidget(zRowCombo, 4)
            if zObjWidget==None: return
            zKeyTarget = self.sender().currentText()
            if self.listCountriesCode.has_key(zKeyTarget):
                zObjWidget.setInputMask("")
                zObjWidget.setInputMask(self.listCountriesCode[zKeyTarget][1])
                zObjWidget.regex = QRegExp(r"%s" % (self.listCountriesCode[zKeyTarget][0]), Qt.CaseSensitive)
            else :
                zObjWidget.setInputMask("")
                zObjWidget.setInputMask("XXXxxxxxxx;X")
                zObjWidget.regex = QRegExp(r"(^+[a-zA-Z_0-9\s]{3,10}$)", Qt.CaseSensitive)                


    def LoadListOfValues(self):
        if self.sender().accessibleName() == "" : return
        zNameObjRac = self.sender().accessibleName().split("_")[0]
        zRowCombo = int(self.sender().accessibleName().split("_")[2])
        zIndexThesaurus = self.sender().currentIndex()
        zObj = getWidget(self, zNameObjRac)
        if zObj != None :
            zObjWidget = zObj.cellWidget(zRowCombo, 1)
            if zObjWidget :
               zObjWidget.clear()
               SizeW, zCols, iLine = LoadFile(self, zObjWidget, "", "file:200:thesaurus_%s" % (zIndexThesaurus)+".csv:0:0", 1, None)

    def FixeToolTipCalendar(self):
        zObjCalendar = getWidget(self, "%s" % (self.sender().accessibleName()))
        zToolTip = MakeToolTipCalendar(self, zObjCalendar)

    def ChangeAccessibility(self, checked):
        if self.sender()==None or self.sender().objectName()=="": return
        else:
           zNameObj = "%s" % (self.sender().accessibleName())
           zObj = getWidget(self, "tablemotsclefsf")
           if zNameObj.find("tablemotsclefsf_action_")!=-1: zIndexLine = int(zNameObj.split("_")[2])
           else: zIndexLine = GetIndex(zObj)

           for i in range(2,5):
               zItemEditLine = zObj.cellWidget(zIndexLine, i)
               try : zItemEditLine.setEnabled(checked)
               except : pass


    def SelectKeyWord(self, item):
        zObj = getWidget(self, "tablecategories")
        zItem = zObj.model().item(item.row(), 1)
        zObjTarget = getWidget(self, "tablemotsclefso")

        if item.checkState() == Qt.Checked : 
            self.MakeLine(zObjTarget, True, False)
            zItemTarget = zObjTarget.cellWidget(zObjTarget.rowCount()-1, 1)
            for i in range(zItemTarget.count()):
                zEltList = zItemTarget.itemText(i)
                if zEltList == zItem.text():
                   zItemTarget.setCurrentIndex(i)
                   break
        else:
            for line in range(zObjTarget.rowCount()):
                zItemTarget = zObjTarget.cellWidget(line, 1)
                if zItemTarget == None : break
                if zItemTarget.currentText() == zItem.text():
                   zObjTarget.removeRow(line)
                   break
        self.countItems("tablemotsclefso", zObjTarget)

    def majItemLangues(self, item): self.CountLangues()
        
    def CountLangues(self):
        zObjLabel = getWidget(self, "Lbltablelangues")
        if not zObjLabel : return
        zObj = getWidget(self, "tablelangues")
        if not zObj : return
        zRows, counter, listlangues = zObj.model().rowCount(), 0, ""
        for i in range(zRows):
            if zObj.model().item(i, 0).checkState()== Qt.Checked:
                counter+= 1
                zNewline = "<br>" if counter % 4 == 0 else ""
                listlangues+= "<b>%s</b> %s" % (zObj.model().item(i, 0).text(), zNewline)
        zRacLabel = QtGui.QApplication.translate("QSphere","Language(s) for the resource : ", None, QtGui.QApplication.UnicodeUTF8)
        zObjLabel.setText("(<b><u>%s</u></b>) %s<br>%s" % (counter, zRacLabel, listlangues))

    def countItems(self, zCible, zObj):
        zObjLabel = getWidget(self, "Lbl%s" % (zCible))
        if zObjLabel : zObjLabel.setText("(<b><u>%s</u></b>) %s" % (zObj.rowCount(), zObjLabel.accessibleDescription()))  

    def cleanAllObj(self, zObj, doCount):
        if not zObj : return
        zObj.clearContents()
        for i in range(zObj.rowCount()): zObj.removeRow(0)
        if doCount : self.countItems(zObj.accessibleName(), zObj)        


    def doDessCadre(self, currentRow, currentColumn, previousRow, previousColumn):
        if currentRow!= previousRow : self.DessCadre()
                    
    def DessCadre(self):
        zBorneLong = int(self.EmpriseLong/2)
        zBorneLat = int(self.EmpriseLat/2)
        zIndexEmp = -1
        
        if self.sender()==None or self.sender().objectName()=="":
           zObj = getWidget(self, "tableemprises")
           zIndexEmp = GetIndex(zObj)
        else:
           zNameObj = "%s" % (self.sender().accessibleName())
           zObj = getWidget(self, "tableemprises")
           if zNameObj.find("tableemprises_")!=-1: zIndexEmp = int(zNameObj.split("_")[2])
           else: zIndexEmp = GetIndex(zObj)

        if zIndexEmp == -1: return
        zItem = zObj.cellWidget(zIndexEmp,0)        
        if zItem == None : return
       
        zItem = zObj.cellWidget(zIndexEmp,2)
        XposD = int(zItem.value())+ zBorneLong

        zItem = zObj.cellWidget(zIndexEmp,3)
        XposF = int(zItem.value())+zBorneLong
       
        zItem = zObj.cellWidget(zIndexEmp,0)
        YposD = zBorneLat-int(zItem.value())

        zItem = zObj.cellWidget(zIndexEmp,1)
        YposF = zBorneLat-int(zItem.value())

        self.zCadre.setGeometry(QtCore.QRect(XposD, YposD, (XposF-XposD), (YposF - YposD)))
        self.zMireH.setGeometry(QtCore.QRect(XposD + int((XposF-XposD)/2), 0, 1, self.EmpriseLat)) 
        self.zMireW.setGeometry(QtCore.QRect(0, YposD - int((YposD-YposF)/2), self.EmpriseLong, 1))


def makeTABWidgets(self, tab, zIndex, SizeLabelW, SizeLabelH, SizeWW, SizeWH):
        refSizeWW, refSizeWH = SizeWW, SizeWH
        zLang = "fr" if self.langueTR == "fr" else "en" 

        zTitles = (QtGui.QApplication.translate("QSphere","Data identification : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Title : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Abstract : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Resource type : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Locator (s) for the resource : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Resource Identifier : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Language(s) for the resource : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Format(s) : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Encoding : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Classification of spatial data and services : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Thematic categories : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Keywords : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Keywords from INSPIRE<br>Data themes & repositories : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","<i>Free</i> keywords : ", None, QtGui.QApplication.UnicodeUTF8), \
                   "", \
                   QtGui.QApplication.translate("QSphere","Location : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Bouding box : ", None, QtGui.QApplication.UnicodeUTF8), \
                   "", \
                   QtGui.QApplication.translate("QSphere","Coordinate reference system(s) : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","SRS : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Temporal informations : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Temporal extent : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Date of publication : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Date of creation : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Date of the last revision : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Temporal reference system : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Quality & validity : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Lineage : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Lineage for the data : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Spatial resolution : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Equivalent scale : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Topological consistency : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Compliance : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Compliance specifications : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Constraint related to access and use : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Conditions applying...\nto access and use : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Conditions licensing applying...\nto access and use : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Responsible party : ", None, QtGui.QApplication.UnicodeUTF8), \
                   "", \
                   QtGui.QApplication.translate("QSphere","Informations about Metadata : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Metadata date : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Metadata language : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Additional Information QGIS QSPHERE : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Name layer : ", None, QtGui.QApplication.UnicodeUTF8), \
                   QtGui.QApplication.translate("QSphere","Type layer : ", None, QtGui.QApplication.UnicodeUTF8), \
                   "", \
                   "", \
                   ""                   
                   )
        zToolTips = (QtGui.QApplication.translate("QSphere","Data identification ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Title of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Abstract of the dataset describing the resource ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Resource type ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Link(s) for the resource ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Identifier for the resource ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","List of language(s) for the resource : ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Different formats of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Character encoding of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Data classification and mapping services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Thematic categories\n(INSPIRE Annexes - INSPIRE Themes - ISO classes ) ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Keywords ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","List of keywords required (INSPIRE Themes) ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","List of optional keywords (INSPIRE Themes) ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Search with GeoVOC", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Information for the location (data required) ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Information for the location (Bouding box) ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","List of the extents of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Information about coordinate reference system(s) (data required) ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","List of reference system(s) of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Temporal informations ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Information about temporal extent (optional data)", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Date of publication of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Date of creation of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Date of the last revision of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Temporal reference system ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Quality & validity", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Lineage of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Lineage of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Spatial resolution of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Equivalent scale of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Topological consistency of spatial data sets and services (data not required) ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Compliance of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","List of compliance specifications of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Constraint related to access and use ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Conditions applying to access and use ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Licensing conditions applying to access and use ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Organisations reponsible for the etablishment, management, maintenance and distribution of spatial data sets and services ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Responsible party role ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Informations about Metadata ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Metadata date ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Metadata language ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Metadata language ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Name Layer ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Type Layer ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Generic metadata QGIS for geographical layer (vector or raster) ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","Fields for the query layer (vector) ", None, QtGui.QApplication.UnicodeUTF8), \
                     QtGui.QApplication.translate("QSphere","QSphere resources ", None, QtGui.QApplication.UnicodeUTF8)                     
                     )

        if zIndex == 1 :
            Widgets = {"A_TITLE" : (0,0,"title", zTitles[0], zToolTips[0], -1, (), "", True, False),
                       "B_Intitule" : (self.width()-530,0,"intitule", zTitles[1], zToolTips[1], 5, (),"file:intitule.html", True, False),
                       "C_Resume" : (self.width()-530,100, "resume", zTitles[2], zToolTips[2], 0, (), "file:resume.html", True, False),
                       "D_Type" : (self.width()-530, 0, "typedata", zTitles[3], zToolTips[3], 1, self.listTypeRessources,"file:type_ressource.html", True, False),
                       "E_Localisator" : (self.width()-530, 15, "tablelocalisator", zTitles[4], zToolTips[4], 6, (), "file:localisateur.html", True, False),
                       "F_Identificator" : (300, 0, "identificator", zTitles[5], zToolTips[5], 5, (), "file:identificateur.html", True, False),
                       "G2_lang" : (0, 0, "tablelangues", zTitles[6], zToolTips[6], 3, "txt:", "file:langue.html", True, False),
                       "H_format" : (220, 0, "tableformats", zTitles[7], zToolTips[7], 6, (), "file:format_fichier.html", True, True),
                       "I_carac" : (120, 0, "tablecarac", zTitles[8], zToolTips[8], 1, self.listCodecs, "file:encodage.html", True, True) 
                      }
        elif zIndex == 2 :
             Widgets = {"A_TITLE" : (0, 0,"title", zTitles[9], zToolTips[9], -1, (), "", True, False),
                        "B_Categorie" : (0, 180,"tablecategories", zTitles[10], zToolTips[10], 3, "file:300:categories_thematiques.csv:1:0", "file:categorie_thematique.html", True, False),
                        "C_TITLE" : (0, 0,"title", zTitles[11], zToolTips[11], -1, (), "", True, False),
                        "D_MotsClefsO" : (self.width()-530, 11,"tablemotsclefso", zTitles[12], zToolTips[12], 6, (), u"file:mots_clefs.html#mot_cle_obligatoire", True, False),
                        "E_MotsClefsF" : (self.width()-530, 11,"tablemotsclefsf", zTitles[13], zToolTips[13], 6, (), u"file:mots_clefs.html#mots_cles_complementaires_facultatifs", True, False),
                        "F_Ressources" : (120, 0,"resscatthegorie", zTitles[14], zToolTips[14], 11, (), "http://geocat.fr/index.php?", True, False)
                      }
   
        elif zIndex == 3 :
             Widgets = {"A_TITLE" : (0, 0, "title", zTitles[15], zToolTips[15], -1, (), "", True, False),
                        "B_TITLE" : (0, 0,"title", zTitles[16], zToolTips[16], -2, (), "", True, False),
                        "C_TableSCR" :(self.width()-530, 20,"tableemprises", zTitles[17], zToolTips[17], 6, (), "file:emprise.html", True, False),
                        "D_TITLE" : (0, 0,"title",  zTitles[18], zToolTips[18], -2, (), "", True, False),
                        "E_TableScr" :(self.width()-905, 0,"tablescr", zTitles[19], zToolTips[19], 6, "EPSG:4258", "file:systeme_de_reference.html", True, False)
                       }

             zMap = QLabel(tab)
             zMap.setMinimumSize(QtCore.QSize(360, 180))
             zMap.setMaximumSize(QtCore.QSize(360, 180))
             zMap.setGeometry(QtCore.QRect(415, 310, 360, 180))
             myDefPathIcon = getLangIcon("world.png")
             carIcon = QtGui.QImage(myDefPathIcon) 
             zMap.setPixmap(QtGui.QPixmap.fromImage(carIcon))

             self.zCadre = MyLabel(zMap)
             self.zMireH = MyLabel(zMap)
             self.zMireW = MyLabel(zMap)

        elif zIndex == 4 : 
            Widgets = {"A_TITLE" : (0, 0,"title", zTitles[20], zToolTips[20], -1, (), "", True, False),
                       "B_Etendue" : (160, 15,"tableetenduetemporelle", zTitles[21], zToolTips[21], 6, (), "file:etendue_temporelle.html#6.1.Etendue temporelle", True, True),
                       "C_DatePub" : (120, 15, "tabledatepubdata", zTitles[22], zToolTips[22], 6, (), "file:dates_reference.html#6.2.1.Date de publication", True, False),
                       "D_DateCre" : (0, 0, "datecredata", zTitles[23], zToolTips[23], 4, (), u"file:dates_reference.html#date_de_creation", True, False),
                       "E_DateRev" : (0, 0, "daterevdata", zTitles[24], zToolTips[24], 4, (), u"file:dates_reference.html#date_de_derniere_revision", True, False),
                       "F_SysRefTemp" : (0, 0, "sysreftemp", zTitles[25], zToolTips[25], 1, self.listTemporalSystem, "file:systeme_de_reference_temporel.html", True, False) 
                      }
        elif zIndex == 5 :
            Widgets = {"A_TITLE" : (0, 0,"title", zTitles[26], zToolTips[26], -1, (), "", True, False),
                       "B_TITLE" : (0, 0,"title", zTitles[27], zToolTips[27], -2, (), "", True, False),
                       "C_Genealogie" : (self.width()-530, 100,"genealogie", zTitles[28], zToolTips[28], 0, (), "file:genealogie.html", True, False),
                       "D_TITLE" : (0, 0,"title", zTitles[29], zToolTips[29], -2, (), "", True, False),
                       "E_Echelle" : (400, 160, "grouperesolutionscale", zTitles[30], zToolTips[30], 8, ((zTitles[30]+" 1/","resolution_scale",25000.00),(QtGui.QApplication.translate("QSphere","Equivalent scale in unit of measure ", None, QtGui.QApplication.UnicodeUTF8),"resolution_pixel",2.0)), "file:resolution_spatiale.html", True, False),
                       "F_Coherence" : (self.width()-530, 0,"coherence", zTitles[31], zToolTips[31], 0, "{'TopologyLevelCode':'unknow', 'GeometricObjectTypeCode':'unknow'}", "file:coherence_topologique.html", False, False),
                       "G_TITLE" : (0, 0,"title", zTitles[32], zToolTips[32], -1, (), "", True, False),
                       "H_Conformite" : (self.width()-530, 15,"tablespecifications", zTitles[33], zToolTips[33], 6, (), "file:conformite_specifications.html", True, False)
                      }


        elif zIndex == 6 :
            Widgets = {"A_TITLE" : (0, 0,"title", zTitles[34], zToolTips[34], -1, (), "", True, False),
                       "B_droits" : (self.width()-530, self.height()-160,"groupedroits", zTitles[35], zToolTips[35], 8, \
                                     ((QtGui.QApplication.translate("QSphere","No restriction for public access in INSPIRE", None, QtGui.QApplication.UnicodeUTF8),"norestriction_droits",25000.00), \
                                      (QtGui.QApplication.translate("QSphere","With restriction for public access in INSPIRE (Directive 2007/2/CE)", None, QtGui.QApplication.UnicodeUTF8),"restriction_droits",2.0)), "file:contraintes.html", True, False), \
                       "C_Licence" : (self.width()-530, 40,"licence", zTitles[36], zToolTips[36], 0, "%s" % ((QtGui.QApplication.translate("QSphere","Open Licence", None, QtGui.QApplication.UnicodeUTF8))), "file:licence.html", True, False)
                      }
        #+1    
        elif zIndex == 7 : 
            Widgets = {"A_TITLE" : (0, 0,"title", zTitles[37], zToolTips[37], -1, (), "", True, False),
                       "B_TableRole" :(self.width()-530, 40,"tableroles", zTitles[38], zToolTips[38], 6, (), "file:organisme_responsable.html", True, False)
                      }
            
        elif zIndex == 8 : 
            Widgets = {"A_TITLE" : (0, 0,"title", zTitles[39], zToolTips[39], -1, (), "", True, False),
                       "B_DateMetadata" : (0, 0, "datemetada", zTitles[40], zToolTips[40], 4, (), "file:date_metadonnee.html", True, False),
                       "C_LangMetadata" : (80, 0, "langmetada", zTitles[41], zToolTips[41], 1, self.languesDico, "file:langue_metadonnee.html", True, False) 
                      }
        elif zIndex == 9 :
            Widgets = {"A_TITLE" : (0, 0,"title", zTitles[42], zToolTips[42], -1, (), "", True, False),
                       "B_NameLayer" : (self.width()-530,0,"namelayer", zTitles[43], zToolTips[43], 5, (),"file:catalogue_attributaire.html", False, False),
                       "C_TypeLayer" : (200,0,"typelayer", zTitles[44], zToolTips[44], 5, (),"file:catalogue_attributaire.html", False, False),
                       "D_Metadata" : (self.width()-530, 150,"metadata", zTitles[45], zToolTips[45], 0, (), "file:catalogue_attributaire.html", True, False),
                       "E_TableDico" :(self.width()-530, 35,"tabledico", zTitles[46], zToolTips[46], 6, (), "file:catalogue_attributaire.html", True, False),
                       "F_Ressources" : (120, 0,"ressicons", zTitles[47], zToolTips[47], 11, (), "file:ressources_qsphere.html", True, False)
                      }
        else : return
        
        posX, posY = 200, 10
         
        zListitems = ShortDic(Widgets)
        for j in range(len(zListitems)):    
            key = zListitems[j]
            ListPropertiesObj = Widgets[key]
            SizeWW =  ListPropertiesObj[0] if ListPropertiesObj[0] != 0 else refSizeWW
            SizeWH =  ListPropertiesObj[1] if ListPropertiesObj[1] != 0 else refSizeWH
            nameObj, txtObj, tooltipObj = ListPropertiesObj[2], ListPropertiesObj[3], ListPropertiesObj[4]
            typeObj, valObj, UrlObj = ListPropertiesObj[5], ListPropertiesObj[6], ListPropertiesObj[7]
            isEnabled, isVertical = ListPropertiesObj[8], ListPropertiesObj[9]
            corPosY = makeWidget(self, tab, txtObj, nameObj, typeObj, tooltipObj, valObj, posX, posY, SizeWW, SizeWH, refSizeWH, UrlObj, isEnabled, isVertical)
            if isVertical : posX+= SizeWW + 200
            else:
               posY+= 30 if corPosY == 0 else corPosY
               posX = 200
            

def makeWidget(self, tab, txtObj, nameObj, typeObj, tooltipObj, valObj, posX, posY, SizeW, SizeH, SizeRefH,  zUrl, zEnable, zVerticalObj):
        lblObj = QLabel(tab)
        lblObj.setObjectName("Lbl"+nameObj)
        lblObj.setAccessibleName("Lbl"+nameObj)
        corPosY = 0

        if typeObj in( -1, -2) :
            lblObj.setGeometry(QtCore.QRect(10,posY+5,self.width(),SizeH))
            if typeObj == -1 :
                lblObj.setAlignment(Qt.AlignLeft)
                lblObj.setStyleSheet("QLabel { background-color : #5D5D5D; color : white; }")
                txtObj = ">> %s" % (txtObj)
            else :
                lblObj.setAlignment(Qt.AlignCenter)
                lblObj.setStyleSheet("QLabel { background-color : #CCCCCC; color : black; }")
            lblObj.setText(txtObj)
            corPosY = SizeH+10 
        else :
            if nameObj=="tablelangues" : lblObj.setGeometry(QtCore.QRect(posX-165,posY+5,165, SizeH*4))
            else : lblObj.setGeometry(QtCore.QRect(posX-165,posY+5,165,self.SizeWH*2))
            lblObj.setAlignment(Qt.AlignRight)
            lblObj.setText(txtObj)
            lblObj.setAccessibleDescription(txtObj)
        
        if typeObj == 0: 
            Obj = QTextEdit(tab) 
            Obj.setAcceptRichText(False)
            Obj.setReadOnly(False)
            Obj.setTabChangesFocus(True)
            #TOTO 2.6.1
            Obj.setWordWrapMode(QTextOption.WordWrap)# .NoWrap)
            zType = "%s" % (type(valObj))
            if zType == "<type 'str'>" : Obj.setText("%s" % (valObj))
            corPosY = SizeH+10   
                
        elif typeObj == 1:
            Obj = QComboBox(tab)
            itemtarget = 0 if nameObj != "sysreftemp" else 1
            if type(valObj) == str :
               if valObj.find("file:")!=-1 :
                   SizeW, zCols, iLine = LoadFile(self, Obj, nameObj, valObj, typeObj, None)
               else :
                   Obj.addItem("%s" % (valObj))
                   SizeW = int(SizeW / 2)
            elif type(valObj) == tuple :
               Obj.insertItems (0, valObj)
               SizeW = int(SizeW / 2)
            elif type(valObj) == dict :    
                myelts = ShortDic(valObj)
                if nameObj == "langmetada" : 
                    mylang = QtCore.QLocale.languageToString(self.langue)
                    itemtarget = MakeListLangues(self, Obj, mylang)
            elif type(valObj) == list :
                if nameObj == "tablecarac" :
                    valObj.sort()
                    Obj.insertItems (0, valObj)
                    itemtarget = valObj.index("utf8")
            Obj.setCurrentIndex(itemtarget)

        
        elif typeObj == 3:
            self.tableModel = QStandardItemModel(self)
            Obj = QTableView(tab)
            if self.SizeWW == SizeW : SizeW =  self.width()-posX - 330
            iLine, zCols = 0, 1

            if type(valObj) == str :
                if valObj.startswith("file:"): 
                   SizeHOld = SizeH
                   SizeH, zCols, iLine = LoadFile(self, Obj, nameObj, valObj, typeObj, self.tableModel)
                   if SizeHOld != SizeRefH: SizeH = SizeHOld
                elif valObj.startswith("txt:"):
                   data_icons = os.path.dirname(__file__).replace("\\","/") +"/ressources/images/"
                   zCols, i = 2, 0
                   mylans = ShortDic(self.languesDico)
                   mylang = QtCore.QLocale.languageToString( self.langue )
                   for elt in mylans :
                        if len(elt)==3 :
                            language_codeiso = elt
                            language_name = self.languesDico[elt]['french']
                            for j in range(zCols):
                                zIcon = QIcon(data_icons+language_codeiso+".png")
                                item = QStandardItem() if j == 0 else QStandardItem(zIcon, "")
                                zText = language_codeiso if j == 0 else language_name
                                item.setText(zText)
                                if j == 0 :
                                   item.setCheckable(True)
                                   item.setCheckState(Qt.Unchecked)
                                   if  nameObj == "tablelangues" and self.languesDico[elt]['english'] == mylang : item.setCheckState(Qt.Checked)
                                item.setEditable(False)    
                                self.tableModel.setItem(i,j,item)
                            i+= 1
                SizeH = SizeH + 70

   
            elif type(valObj) == list :
                #This case not active in current version - keep and save
                zCols = 2
                for i in range(len(valObj)):
                    language = valObj[i]
                    language_name = QtCore.QLocale.languageToString( language ) 
                    language_codeiso = QtCore.QLocale( language ).name().split("_")[0]
                    language_index_target = QtCore.QLocale.languageToString( language ) 
           
                    for j in range(zCols):
                        item = QStandardItem()
                        zText = language_codeiso if j == 0 else language_name
                        if j == 0 :
                            item.setCheckable(True)
                            item.setCheckState(Qt.Unchecked)
                            if self.languageindex == language_index_target: item.setCheckState(Qt.Checked)
                        item.setEditable(False)    
                        item.setText(zText)
                        self.tableModel.setItem(i,j,item)
                SizeH = SizeH + 70
                
            else :
                #This case not active in current version - keep and save
                for i in range(len(valObj)):
                    if type(valObj[i]) == str :
                        item = QStandardItem()
                        item.setCheckable(True)
                        item.setCheckState(Qt.Unchecked)
                        zText = "%s" % (valObj[i][j])
                        item.setText(zText)
                        item.setEditable(False)
                        self.tableModel.setItem(iLine,0,item)
                        
                    elif type(valObj[i]) == tuple :
                        zCols = len(valObj[i])
                        for j in range(len(valObj[i])):
                            item = QStandardItem() 
                            zText = "%s" % (valObj[i][j])
                            item.setText(zText)                            
                            if j == 0 :
                                item.setCheckable(True)
                                item.setCheckState(Qt.Unchecked)
                                #This case not active in current version - keep and save
                                #old sample flag language - keep and save
                                if nameObj == "tablelangues" and item.text().startswith(self.langueTR): item.setCheckState(Qt.Checked)
                            item.setEditable(False)    
                            self.tableModel.setItem(iLine,j,item)
                      
                    iLine+= 1
                SizeH = SizeH * (iLine+1) + 30

            for i in range(zCols): Obj.setColumnWidth(i, int(SizeW/zCols)-10)
            Obj.horizontalHeader().setDefaultSectionSize(int(SizeW/zCols)-10)
            if nameObj == "tabledroits" : Obj.verticalHeader().setDefaultSectionSize(60)
            Obj.horizontalHeader().setVisible(False) 
            Obj.verticalHeader().setVisible(False) 
            Obj.setModel(self.tableModel)

            if nameObj=="tablelangues": QtCore.QObject.connect(Obj.model(),QtCore.SIGNAL("itemChanged(QStandardItem*)"),self.majItemLangues)
            
            corPosY =  SizeH + 10


        elif typeObj == 4:    
            Obj = QCalendarWidget(tab)
            Obj.setStyleSheet("""QMenu { font-size:14px; width: 150px; left: 16px; background-color:qlineargradient(x1:0, y1:0, x2:0, y2:1, stop: 0 #cccccc, stop: 1 #5D5D5D);}"""
                              """QToolButton {icon-size: 20px, 20px;background-color: qlineargradient(x1:0, y1:0, x2:0, y2:1, stop: 0 #cccccc, stop: 1 #5D5D5D); height: 20px; width: 200px;}"""
                              """QAbstractItemView {selection-background-color: rgb(255, 174, 0);}"""
                              """QToolButton::menu-arrow {}"""
                              """QToolButton::menu-button {}"""
                              """QToolButton::menu-indicator{width: 5px;}"""
                              """QToolButton::menu-indicator:pressed,"""
                              """QToolButton::menu-indicator:open{top:10px; left: 20px;}"""
                              """QListView {background-color:white;}"""
                              """subcontrol-position: top right; width:50px; border-image: url(icons:arrow_up_n.png);}"""
                              """border-width: 1px; width:25px;}"""
                              )
       

            Obj.setGridVisible(True)
            Obj.showToday()
            QtCore.QObject.connect(Obj,QtCore.SIGNAL("selectionChanged()"),self.FixeToolTipCalendar)
            tooltipObj = MakeToolTipCalendar(self, Obj)
            SizeH = 170 
            corPosY = SizeH + 10 
            SizeW = SizeW + 35

        elif typeObj in(5, 50):
            if typeObj == 5 : Obj = QLineEdit(tab)
            elif typeObj == 50 :
                 Obj = MyWidgetLineEdit(tab)
                 zText = valObj.split(":")
                 Obj.initType(int(zText[0]))
                 if int(zText[0])== 1: Obj.setInputMask("9999-99-99 9999-99-99;X")
                 elif int(zText[0])== 2: Obj.setInputMask("99999;X")
                 elif int(zText[0])== 5: Obj.setInputMask("9999-99-99;X")
                 valObj = zText[1]
                 Obj.setAlignment(Qt.AlignCenter)
                 QtCore.QObject.connect(Obj,QtCore.SIGNAL("textChanged(const QString &)"),Obj.VerifExpReg)
            Obj.setText("") if nameObj != "identificator" else Obj.setText("%s-%s-%s" % (self.langueTR.upper(), datetime.datetime.now().year, getRandowId(self)))


        elif typeObj == 6 : 
            if nameObj == "tableroles" : zCols = 7
            elif nameObj in ("tableemprises", "tablemotsclefsf") : zCols = 5
            elif nameObj == "tablespecifications" : zCols = 4
            elif nameObj == "tableformats"  : zCols = 3
            elif nameObj in ("tablemotsclefso", "tablescr", "tablelocalisator") : zCols = 2 
            elif nameObj in ("tabledatepubdata", "tableetenduetemporelle") : zCols = 1 
            else : zCols = 6 

            Obj = QTableWidget(0, zCols, tab)
            Obj.setObjectName(nameObj)
            Obj.setAccessibleName(nameObj)

            if nameObj == "tablescr" :
                zDim = (120, 40)
                for i in range(len(zDim)): Obj.setColumnWidth(i, zDim[i])
                zListHeaders = (QtGui.QApplication.translate("QSphere","Selected SRS", None, QtGui.QApplication.UnicodeUTF8),"") 

            elif nameObj == "tableetenduetemporelle" :
                Obj.setColumnWidth(0, 140)
                zListHeaders = (QtGui.QApplication.translate("QSphere"," Start <-> End ", None, QtGui.QApplication.UnicodeUTF8),"") 

            elif nameObj == "tabledatepubdata" :
                Obj.setColumnWidth(0, 100)
                zListHeaders = ("date","")

            elif nameObj == "tabledico" : 
                zDim = (50, 150, 70, 60, 50, 150)
                for i in range(len(zDim)): Obj.setColumnWidth(i, zDim[i])
                zListHeaders = ("Id", \
                                QtGui.QApplication.translate("QSphere","Name", None, QtGui.QApplication.UnicodeUTF8), \
                                "Type", \
                                QtGui.QApplication.translate("QSphere","Length", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Precision", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Comment", None, QtGui.QApplication.UnicodeUTF8)) 

            elif nameObj == "tablemotsclefso" :
                zDim = (200, 300)
                for i in range(len(zDim)): Obj.setColumnWidth(i, zDim[i])
                zListHeaders = (QtGui.QApplication.translate("QSphere","Thematic", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Keyword", None, QtGui.QApplication.UnicodeUTF8)) 

            elif nameObj == "tableformats" :
                zDim = (80, 40, 80)
                for i in range(len(zDim)): Obj.setColumnWidth(i, zDim[i])
                zListHeaders = ("Format", "", "Version")
                SizeH = 10

            elif nameObj == "tablemotsclefsf" :
                zDim = (150, 25, 140, 80, 90)
                for i in range(len(zDim)): Obj.setColumnWidth(i, zDim[i])
                zListHeaders = (QtGui.QApplication.translate("QSphere","Keyword", None, QtGui.QApplication.UnicodeUTF8), \
                                "", \
                                QtGui.QApplication.translate("QSphere","Controlled vocabulary ", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Date", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Date type", None, QtGui.QApplication.UnicodeUTF8)) 

            elif nameObj == "tablespecifications" :
                zDim = (240, 80, 100, 100)
                for i in range(len(zDim)): Obj.setColumnWidth(i, zDim[i])
                zListHeaders = (QtGui.QApplication.translate("QSphere","Specification", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Date", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Date type", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Class", None, QtGui.QApplication.UnicodeUTF8)) 

 
            elif nameObj == "tablelocalisator" :
                zDim = (190, 200)
                for i in range(len(zDim)): Obj.setColumnWidth(i, zDim[i])
                zListHeaders = (QtGui.QApplication.translate("QSphere","URL", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Name", None, QtGui.QApplication.UnicodeUTF8)) 

            elif nameObj == "tableemprises" :
                zDim = (140, 140, 140, 140, 80)
                for i in range(len(zDim)): Obj.setColumnWidth(i, zDim[i])
                zListHeaders = (QtGui.QApplication.translate("QSphere","North lat.", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","South lat.", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","West long.", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","East long.", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Extent", None, QtGui.QApplication.UnicodeUTF8))
                QtCore.QObject.connect(Obj, QtCore.SIGNAL("currentCellChanged(int, int, int, int )"), self.doDessCadre)
                

            elif nameObj == "tableroles" :
                zDim = (160, 100, 140, 60, 60, 80, 200)
                for i in range(len(zDim)): Obj.setColumnWidth(i, zDim[i])
                zListHeaders = (QtGui.QApplication.translate("QSphere","Role", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Organization name", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Address", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Country", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","Zip code", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","City", None, QtGui.QApplication.UnicodeUTF8), \
                                QtGui.QApplication.translate("QSphere","E-mail", None, QtGui.QApplication.UnicodeUTF8)) 

     
            self.MakeLine(Obj, False, True) 
            Obj.setHorizontalHeaderLabels(zListHeaders)              
            Obj.verticalHeader().setVisible(False)
            SizeH = (SizeH * 7) + 30
            corPosY = posY + SizeH if nameObj not in("tabledico", "tableformats", "tablelocalisator", "tableemprises", "tablemotsclefso", "tablemotsclefsf") else SizeH + 10

        elif typeObj == 8:
            Obj = QGroupBox(tab)
            yypos = 5
            for i in range(len(valObj)):
                zProps = valObj[i]
                zRadioButton = QRadioButton(Obj)
                zRadioButton.setObjectName(zProps[1])
                zRadioButton.setAccessibleName(zProps[1])
                zRadioButton.setText("%s" % (zProps[0]))
                if nameObj == "grouperesolutionscale" : zToolTip = "%s" % (zProps[2])
                else : zToolTip = QtGui.QApplication.translate("QSphere","Constraints", None, QtGui.QApplication.UnicodeUTF8)
                #TOTO 2.6.1
                #zRadioButton.setToolTip(str(zProps[2])) if nameObj == "grouperesolutionscale" else zRadioButton.setToolTip(QtGui.QApplication.translate("QSphere","Constraints", None, QtGui.QApplication.UnicodeUTF8))
                zRadioButton.setToolTip(zToolTip)
                zRadioButton.setGeometry(QtCore.QRect(5,yypos,540,25))
                if i == 0 :  zRadioButton.setChecked(True)
                if nameObj == "grouperesolutionscale" : QtCore.QObject.connect(zRadioButton, QtCore.SIGNAL("clicked()"), self.ChangeOptionScale)
                elif nameObj == "groupedroits" : QtCore.QObject.connect(zRadioButton, QtCore.SIGNAL("toggled(bool)"), self.ChangeOptionRights)
                yypos+= 25
                
            if nameObj == "grouperesolutionscale": 
               zSubObj = QTableWidget(1,1, Obj)
               zSubObj.setObjectName("tableechelles")
               zSubObj.setAccessibleName("tableechelles")
               zSubObj.horizontalHeader().setVisible(False)
               zSubObj.verticalHeader().setVisible(False)
               zSubObj.setGeometry(QtCore.QRect(240,0,140,SizeH-10))
               AddLineWidget(self, zSubObj, 0,  0, 4, 0, -1)
            elif nameObj == "groupedroits":
               self.tableModel = QStandardItemModel(self)
               zSubObj = QTableView(Obj)
               zNameTable = "table%s" % (nameObj)
               zSubObj.setObjectName(zNameTable)
               zSubObj.setAccessibleName(zNameTable)
               iLine, zCols = 0, 1

               zLang = "fr" if self.langueTR == "fr" else "en"
               SizezSubObjH, zCols, iLine = LoadFile(self, zSubObj, zNameTable, "file:280:contraintes_%s.csv:1:0" % (zLang), 3, self.tableModel)
               zSubObj.setGeometry(QtCore.QRect(10,60, (SizeW-20), SizeH-70))
               
               for i in range(zCols): zSubObj.setColumnWidth(i, int((SizeW-20)/zCols)-10)
               zSubObj.horizontalHeader().setDefaultSectionSize(int((SizeW-20)/zCols)-10)
               zSubObj.verticalHeader().setDefaultSectionSize(60)
               zSubObj.horizontalHeader().setVisible(False) 
               zSubObj.verticalHeader().setVisible(False) 
               zSubObj.setModel(self.tableModel)
               zSubObj.setEnabled(False)


            if nameObj == "grouperesolutionscale": 
                zChildInfo = QComboBox(Obj)
                zChildInfo.addItems(self.ListUnitsMesure) #["m", "km", "foot", "inch", "mile", "yard"])
                zChildInfo.setGeometry(QtCore.QRect(100,60, 80,25))
                zChildInfo.setEnabled(False)
            corPosY = SizeH + 10

      
        if typeObj == 11:
           Obj = QCommandLinkButton(tab)
           Obj.setText(tooltipObj)
           Obj.setToolTip(zUrl)
           QtCore.QObject.connect(Obj,QtCore.SIGNAL("clicked()"),self.AfficheRessources)
           SizeW = 1.5 * SizeW
           SizeH = 1.5 * SizeH


        if typeObj != -1 and  typeObj != -2 :
            if txtObj == "" and typeObj != 11:
               posX = 20
               SizeW+= 180

            Obj.setGeometry(QtCore.QRect(posX,posY,SizeW, SizeH))
            if typeObj != 11 : Obj.setToolTip(tooltipObj)
            Obj.setObjectName(nameObj)
            Obj.setAccessibleName(nameObj)
            Obj.setAccessibleDescription("Informations blocs XML INSPIRE")
            Obj.setEnabled(zEnable)

            if typeObj != 11 :
                if nameObj == "coherence" and typeObj == 0 :
                   zBut = MyButton(tab)
                   zToolTip = QtGui.QApplication.translate("QSphere","Call the topology conformity dialog box", None, QtGui.QApplication.UnicodeUTF8) 
                   zBut.initButton(35, 25, (posX + SizeW - 35), posY, "topo_"+nameObj, "...", zToolTip, True, True) 
                   QtCore.QObject.connect(zBut,QtCore.SIGNAL("clicked()"),self.CallSelectorConformityInfos)

                zBut = MyPushButton(tab)
                zIcon = getThemeIcon("info.png")
                zBut.initPushButton(24, 24, (posX + SizeW + 5), posY, "help_%s" % (nameObj), "", QtGui.QApplication.translate("QSphere","Get informations for this topic", None, QtGui.QApplication.UnicodeUTF8), True, zIcon, 24, 24, True)
                zBut.setAccessibleDescription(zUrl)
                QtCore.QObject.connect(zBut,QtCore.SIGNAL("clicked()"),self.AfficheHelp)

            if typeObj in(6, 8, 9) and not nameObj in ("tabledico", "groupedroits") :

               if nameObj == "tablelocalisator" :
                   zBut = MyPushButton(tab)
                   zIcon = getThemeIcon("localisator.png")
                   zToolTip = QtGui.QApplication.translate("QSphere","View the localisator", None, QtGui.QApplication.UnicodeUTF8) 
                   zBut.initPushButton(24, 24, (posX + SizeW + 5), posY + 30, "URL_%s_%s" % (typeObj, nameObj), "", zToolTip, True, zIcon, 24, 24, True) 
                   QtCore.QObject.connect(zBut,QtCore.SIGNAL("clicked()"),self.goToLocalisator)
                   posY+= 30 

                   
               zBut = MyPushButton(tab)
               zIcon = getThemeIcon("addline.png")
               zToolTip = QtGui.QApplication.translate("QSphere","Add a item", None, QtGui.QApplication.UnicodeUTF8) 
               zBut.initPushButton(24, 24, (posX + SizeW + 5), posY + 30, "Ajouter_%s_%s" % (typeObj, nameObj), "", zToolTip, True, zIcon, 24, 24, True) 
               QtCore.QObject.connect(zBut,QtCore.SIGNAL("clicked()"),self.AddLine)

               zBut = MyPushButton(tab)
               zIcon = getThemeIcon("delline.png")
               zToolTip = QtGui.QApplication.translate("QSphere","Delete the last item", None, QtGui.QApplication.UnicodeUTF8) 
               zBut.initPushButton(24, 24, (posX + SizeW + 5), posY + 60, "Effacer_%s_%s" % (typeObj, nameObj), "", zToolTip, True, zIcon, 24, 24, True) 
               QtCore.QObject.connect(zBut,QtCore.SIGNAL("clicked()"),self.DelLine)

            if nameObj == "scr" :
               zBut = MyButton(tab)
               zToolTip = QtGui.QApplication.translate("QSphere","Call the QGIS SRS dialog box", None, QtGui.QApplication.UnicodeUTF8) 
               zBut.initButton(25, 25, (posX + SizeW + 35), posY, "prj_%s" % (nameObj), "...", zToolTip, True, True) 
               QtCore.QObject.connect(zBut,QtCore.SIGNAL("clicked()"),self.CallQgsProjectionSelector)
                
        if zVerticalObj : corPosY = 0
        if nameObj == "tableemprises" : Obj.setToolTip("0")
        return corPosY
    


#========================================================
# FUNCTIONS CONSTRUCT LIST LAYERS / EXTRACT INFOS LAYERS
#========================================================
def MakeListLayer(self, zModel, zCombo):
    nLayers = self.iface.legendInterface().layers()
    Name_layer = QtGui.QStandardItem(QtGui.QApplication.translate("QSphere","No layer", None, QtGui.QApplication.UnicodeUTF8))
    ID_layer = QtGui.QStandardItem("-1")
    zModel.appendRow([Name_layer, ID_layer]) 
    for i in range(0, len(nLayers)):
        zLayer = nLayers[i]
        if zLayer.isValid():
           Name_layer = QtGui.QStandardItem("%s" % (zLayer.name()))
           ID_layer = QtGui.QStandardItem("%s" % (zLayer.id()))
           zModel.appendRow([Name_layer, ID_layer])               
    view = QtGui.QTreeView()
    view.header().hide()
    view.setRootIsDecorated(False)

    zCombo.setView(view)
    zCombo.setModel(zModel)
    zCombo.show()
    zCombo.setCurrentIndex(0)          

def GetLayerCombo(self, zModel, zCombo, zInLegend):
    zLayer = None
    if zCombo.currentIndex()== 0 : return
    zText = zModel.item(zCombo.currentIndex(),1).text()
    if zInLegend : tLayers = self.iface.legendInterface().layers()
    nLayers = len(tLayers) if zInLegend  else  self.iface.mapCanvas().layerCount()
    for i in range(0, nLayers):
        zLayer = tLayers[i] if zInLegend else self.iface.mapCanvas().layer(i)
        #if str(zLayer.id()) == str(zText): break
        #TOTO 2.6.1
        zId = "%s" % (zLayer.id())
        if zId == zText: break
    return zLayer


def DefzTransform(zLayer, zProj4Dest):
    destinationCRS = QgsCoordinateReferenceSystem()
    destinationCRS.createFromId(zProj4Dest)
    sourceCRS = zLayer.crs()
    zTransform = QgsCoordinateTransform()
    zTransform.setSourceCrs(sourceCRS)
    zTransform.setDestCRS(destinationCRS)
    return zTransform


def LoadData(self, zFile, zType):
    zPath = os.path.dirname(__file__)
    zPath = zPath.replace("\\","/")
    zFileCSV = zPath +zFile.replace("file:","")
    zListData = [] 
    zMListData = {} 
    i=0
    
    if os.path.exists(zFileCSV) :
       f = open(zFileCSV, "r")
       while 1:
             zText = f.readline()
             if zText == "" : break
             if zText.find(";")!=-1 :
                zValue = zText.split(";")
                zVal = zValue[1].replace("\"","").rstrip()
                zListData.append("%s" % (zVal))
                zMListData[i]= zValue[0].replace("\"","").rstrip()
             else:
                zVal = zText.replace("\"","").rstrip()
                zListData.append("%s" (zVal))
             i+= 1
       f.close()
    else:
       if zType == "roles":
           zItem0 = QtGui.QApplication.translate("QSphere","Owner", None, QtGui.QApplication.UnicodeUTF8)
           zItem1 = QtGui.QApplication.translate("QSphere","Point of contact", None, QtGui.QApplication.UnicodeUTF8)
           zListData = [zItem0, zItem1]
           zMListData[0]="owner"
           zMListData[1]="pointOfContact"
       elif zType == "langues" :
           zItem0 = QtGui.QApplication.translate("QSphere","French", None, QtGui.QApplication.UnicodeUTF8)
           zListData = [zItem0, zItem0]
           zMListData[0]="fra"
           zMListData[1]="fre"
       elif zType == "thesaurus":
           zListData = ["GEMET INSPIRE Themes"]
           zMListData[0]="2008-06-01"
           
    return zListData, zMListData

def LoadDefautValue(self, zFile):       
    zPath = os.path.dirname(__file__)
    zPath = zPath.replace("\\","/")
    zFileCSV = zPath +zFile.replace("file:","")
    zMListData = {}
    i=0

    if os.path.exists(zFileCSV) :
           f = open(zFileCSV, "r")
           while 1:
                 zText = f.readline()
                 if zText == "" : break
                 if zText.find(";")!=-1 :
                    zValue = zText.split(";")
                    zListData = []
                    for j in range(len(zValue)):
                        zVal = zValue[j].replace("\"","").rstrip()
                        zListData.append("%s" % (zVal))
                    zMListData[i] = zListData
                 else:
                    zListData = []
                    zVal = zText.replace("\"","").rstrip()
                    zListData.append("%s" % (zVal))
                    zMListData[0] = zListData
                 i+= 1
           f.close()
    return zMListData 
   


